/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.policies;

import com.guardtime.ksi.Extender;
import com.guardtime.ksi.PublicationsHandler;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicy;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicyAdapter;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.UserProvidedPublicationBasedVerificationPolicy;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ContextAwarePolicyAdapterTest {
    @Test
    public void testInternalVerificationPolicyCreation() {
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createInternalPolicy();
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"Internal verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getExtendingService());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getPublicationsHandler());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertFalse((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test
    public void testKeyBasedVerificationPolicyCreation() {
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createKeyPolicy((PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)));
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"Key-based verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getExtendingService());
        Assert.assertNotNull((Object)policy.getPolicyContext().getPublicationsHandler());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertFalse((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Publications handler can not be null")
    public void testKeyBasedVerificationPolicyCreationNoPublicationsHandler() {
        ContextAwarePolicyAdapter.createKeyPolicy(null);
    }

    @Test
    public void testPublicationsFileBasedVerificationPolicyCreation() {
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createPublicationsFilePolicy((PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)));
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"Publications file based verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getExtendingService());
        Assert.assertNotNull((Object)policy.getPolicyContext().getPublicationsHandler());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertFalse((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Publications handler can not be null")
    public void testPublicationsFileBasedVerificationPolicyCreationNoPublicationsHandler() {
        ContextAwarePolicyAdapter.createPublicationsFilePolicy(null);
    }

    @Test
    public void testCalendarBasedVerificationPolicyCreation() {
        Extender extender = (Extender)Mockito.mock(Extender.class);
        Mockito.when((Object)extender.getExtendingService()).thenReturn(Mockito.mock(KSIExtendingService.class));
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createCalendarPolicy((Extender)extender);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"Calendar-based verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        Assert.assertNotNull((Object)policy.getPolicyContext().getExtendingService());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getPublicationsHandler());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertTrue((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Extender can not be null")
    public void testCalendarBasedVerificationPolicyCreationNoExtender() {
        ContextAwarePolicyAdapter.createCalendarPolicy(null);
    }

    @Test
    public void testUserProvidedPublicationBasedVerificationPolicyCreation() {
        Extender extender = (Extender)Mockito.mock(Extender.class);
        Mockito.when((Object)extender.getExtendingService()).thenReturn(Mockito.mock(KSIExtendingService.class));
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)((PublicationData)Mockito.mock(PublicationData.class)));
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"User provided publication based verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getExtendingService());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getPublicationsHandler());
        Assert.assertNotNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertFalse((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test
    public void testUserProvidedPublicationBasedVerificationPolicyFullCreation() {
        Extender extender = (Extender)Mockito.mock(Extender.class);
        Mockito.when((Object)extender.getExtendingService()).thenReturn(Mockito.mock(KSIExtendingService.class));
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)((PublicationData)Mockito.mock(PublicationData.class)), (Extender)extender);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"User provided publication based verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        Assert.assertNotNull((Object)policy.getPolicyContext().getExtendingService());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getPublicationsHandler());
        Assert.assertNotNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertTrue((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Publication data can not be null")
    public void testUserProvidedPublicationBasedVerificationPolicyCreationNoPublicationData() {
        ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy(null, (Extender)((Extender)Mockito.mock(Extender.class)));
    }

    @Test
    public void testUserProvidedPublicationBasedVerificationPolicyCreationNoExtender() {
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)((PublicationData)Mockito.mock(PublicationData.class)), null);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"User provided publication based verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getExtendingService());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getPublicationsHandler());
        Assert.assertNotNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertFalse((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test
    public void testDefaultVerificationPolicyCreation() {
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)), null);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"Default verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getExtendingService());
        Assert.assertNotNull((Object)policy.getPolicyContext().getPublicationsHandler());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertFalse((boolean)policy.getPolicyContext().isExtendingAllowed());
        Assert.assertEquals(policy.getFallbackPolicy().getClass(), KeyBasedVerificationPolicy.class);
    }

    @Test
    public void testPolicyCreation() {
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createPolicy((Policy)new KeyBasedVerificationPolicy(), (PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)), (KSIExtendingService)((KSIExtendingService)Mockito.mock(KSIExtendingService.class)));
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((String)policy.getName(), (String)"Key-based verification policy");
        Assert.assertNotNull((Object)policy.getType());
        Assert.assertNotNull((Object)policy.getRules());
        Assert.assertNotNull((Object)policy.getPolicyContext());
        Assert.assertNotNull((Object)policy.getPolicyContext().getExtendingService());
        Assert.assertNotNull((Object)policy.getPolicyContext().getPublicationsHandler());
        AssertJUnit.assertNull((Object)policy.getPolicyContext().getUserPublication());
        AssertJUnit.assertTrue((boolean)policy.getPolicyContext().isExtendingAllowed());
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Publications handler can not be null")
    public void testPolicyCreationNoPublicationsHandler() {
        ContextAwarePolicyAdapter.createPolicy((Policy)new KeyBasedVerificationPolicy(), null, (KSIExtendingService)((KSIExtendingService)Mockito.mock(KSIExtendingService.class)));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Extending service can not be null")
    public void testPolicyCreationNoExtender() {
        ContextAwarePolicyAdapter.createPolicy((Policy)new KeyBasedVerificationPolicy(), (PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)), null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Unsupported verification policy.")
    public void testPolicyCreationUnsupportedPolicy() {
        ContextAwarePolicyAdapter.createPolicy((Policy)new UserProvidedPublicationBasedVerificationPolicy(), (PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)), (KSIExtendingService)((KSIExtendingService)Mockito.mock(KSIExtendingService.class)));
    }

    @Test
    public void testSetFallbackPolicy() {
        ContextAwarePolicy keyBasedPolicy = ContextAwarePolicyAdapter.createPolicy((Policy)new KeyBasedVerificationPolicy(), (PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)), (KSIExtendingService)((KSIExtendingService)Mockito.mock(KSIExtendingService.class)));
        ContextAwarePolicy userProvidedPublicationPolicy = ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)((PublicationData)Mockito.mock(PublicationData.class)), null);
        userProvidedPublicationPolicy.setFallbackPolicy((Policy)keyBasedPolicy);
        Assert.assertNotNull((Object)userProvidedPublicationPolicy.getFallbackPolicy());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Fallback policy must be instance of ContextAwarePolicy")
    public void testSetInvalidFallbackPolicy() {
        ContextAwarePolicy keyBasedPolicy = ContextAwarePolicyAdapter.createPolicy((Policy)new KeyBasedVerificationPolicy(), (PublicationsHandler)((PublicationsHandler)Mockito.mock(PublicationsHandler.class)), (KSIExtendingService)((KSIExtendingService)Mockito.mock(KSIExtendingService.class)));
        ContextAwarePolicy userProvidedPublicationPolicy = ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)((PublicationData)Mockito.mock(PublicationData.class)), null);
        keyBasedPolicy.setFallbackPolicy((Policy)new KeyBasedVerificationPolicy());
        userProvidedPublicationPolicy.setFallbackPolicy((Policy)keyBasedPolicy);
    }
}

