/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.pdu.PduVersion;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationsFile;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationContextBuilder;
import org.mockito.Mockito;

public abstract class AbstractRuleTest {
    protected VerificationContext build(KSISignature signature) throws Exception {
        return this.build(signature, null, TestUtil.loadPublicationsFile("publications-files/publications.tlv"), null, null);
    }

    protected VerificationContext build(KSISignature signature, PublicationData publication) throws Exception {
        return this.build(signature, null, TestUtil.loadPublicationsFile("publications-files/publications.tlv"), publication, null);
    }

    protected VerificationContext build(KSISignature signature, PublicationsFile trustStore) throws Exception {
        return this.build(signature, null, trustStore, null, null);
    }

    protected VerificationContext build(KSISignature signature, DataHash documentHash) throws Exception {
        return this.build(signature, documentHash, TestUtil.loadPublicationsFile("publications-files/publications.tlv"), null, null);
    }

    protected VerificationContext build(KSISignature signature, Long level) throws Exception {
        return this.build(signature, null, TestUtil.loadPublicationsFile("publications-files/publications.tlv"), null, level);
    }

    protected VerificationContext build(KSISignature signature, DataHash documentHash, PublicationsFile trustStore, PublicationData publication, Long level) {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        KSIExtenderClient mockedExtenderClient = (KSIExtenderClient)Mockito.mock(KSIExtenderClient.class);
        Mockito.when((Object)mockedExtenderClient.getPduVersion()).thenReturn((Object)PduVersion.V2);
        builder.setPublicationsFile(trustStore).setExtenderClient(mockedExtenderClient).setUserPublication(publication);
        return builder.setSignature(signature).setDocumentHash(documentHash, level).build();
    }
}

