/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.AggregationChainInputHashVerificationRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AggregationChainInputHashVerificationRuleTest
extends AbstractRuleTest {
    private Rule rule = new AggregationChainInputHashVerificationRule();

    @Test
    public void testSignatureWithoutRfc3161RecordReturnsOkStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertEquals((String)result.getRuleName(), (String)AggregationChainInputHashVerificationRule.class.getSimpleName());
    }

    @Test
    public void testSignatureWithValidRfc3161RecordChainsReturnsOkStatus_Ok() throws Exception {
        Assert.assertEquals((Object)this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig"))).getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testSignatureWithInvalidRfc3161RecordChainsReturnsFailStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/rfc3161-record/invalid-signature-rfc3161-input-hash-wrong.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.INT_01);
    }
}

