/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.AggregationHashChainLinkMetadataRule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AggregationHashChainLinkMetadataRuleTest
extends AbstractRuleTest {
    private AggregationHashChainLinkMetadataRule rule = new AggregationHashChainLinkMetadataRule();

    @Test
    public void testCorrectMetadataWithPadding() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithMissingPaddingNotMistakenForHashImprint() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-missing-tag.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithPaddingNotFirstElement() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-wrong-order.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithMultiplePadding() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-multiple-tags.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithTooLongPadding() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-value-too-long.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithInvalidPaddingContent() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-wrong-value.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithPaddingForwardFlagNotSet() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-non-forward-flag-not-set.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithPaddingNonCriticalFlagNotSet() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-non-critical-flag-not-set.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithPaddingTLV16FlagSet() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-tlv16-flag-set.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithPaddingNoFlagsSet() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-flags-not-set.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataWithPaddingTooShort() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-value-too-short.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }

    @Test
    public void testMetadataMatchesHashImprint() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-matches-imprint.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)this.rule.getErrorCode(), (Object)VerificationErrorCode.INT_11);
    }
}

