/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.publication.PublicationsFile;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.CalendarAuthenticationRecordSignatureVerificationRule;
import com.guardtime.ksi.util.Base16;
import com.guardtime.ksi.util.X509CertUtil;
import java.security.cert.X509Certificate;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CalendarAuthenticationRecordSignatureVerificationRuleTest {
    private CalendarAuthenticationRecordSignatureVerificationRule rule = new CalendarAuthenticationRecordSignatureVerificationRule();
    private VerificationContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.context = (VerificationContext)Mockito.mock(VerificationContext.class);
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        Mockito.when((Object)this.context.getSignature()).thenReturn((Object)signature);
        Mockito.when((Object)this.context.getCalendarAuthenticationRecord()).thenReturn((Object)signature.getCalendarAuthenticationRecord());
        Mockito.when((Object)this.context.getCalendarHashChain()).thenReturn((Object)signature.getCalendarHashChain());
    }

    @Test
    public void testSignatureWithCorrectCalendarAuthenticationRecordReturnsOkStatus_Ok() throws Exception {
        PublicationsFile pubFile = TestUtil.loadPublicationsFile("publications-files/publications.tlv");
        Mockito.when((Object)this.context.getCertificate((byte[])Mockito.any(byte[].class))).thenReturn((Object)pubFile.findCertificateById(Base16.decode((String)"5aeddd35")));
        Assert.assertEquals((Object)this.rule.verify(this.context).getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testSignatureVerificationUsesUnknownAlgorithmReturnsFailedStatus_Ok() throws Exception {
        X509Certificate mockCertificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)mockCertificate.getSigAlgName()).thenReturn((Object)"INVALID_ALG");
        Mockito.when((Object)this.context.getCertificate((byte[])Mockito.any(byte[].class))).thenReturn((Object)mockCertificate);
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.KEY_02);
    }

    @Test
    public void testSignatureContainsInvalidPKISignatureThenReturnsFailedStatus_Ok() throws Exception {
        Mockito.when((Object)this.context.getCertificate((byte[])Mockito.any(byte[].class))).thenReturn((Object)X509CertUtil.toCert((byte[])TestUtil.loadBytes("cert.crt")));
        Assert.assertEquals((Object)this.rule.verify(this.context).getResultCode(), (Object)VerificationResultCode.FAIL);
    }
}

