/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.unisignature.CalendarHashChain;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.CalendarHashChainDoesNotExistRule;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CalendarHashChainDoesNotExistRuleTest {
    private CalendarHashChainDoesNotExistRule rule = new CalendarHashChainDoesNotExistRule();
    private VerificationContext mockedContext;

    @BeforeMethod
    public void setUp() throws Exception {
        this.mockedContext = (VerificationContext)Mockito.mock(VerificationContext.class);
    }

    @Test
    public void testVerifySignatureWithoutCalendarHashChain_Ok() throws Exception {
        Mockito.when((Object)this.mockedContext.getCalendarHashChain()).thenReturn(null);
        RuleResult result = this.rule.verify(this.mockedContext);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testVerifySignatureWithCalendarHashChain_Ok() throws Exception {
        Mockito.when((Object)this.mockedContext.getCalendarHashChain()).thenReturn(Mockito.mock(CalendarHashChain.class));
        RuleResult result = this.rule.verify(this.mockedContext);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }
}

