/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.CompositeRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CompositeRuleTest {
    private Rule mockedRule1;
    private Rule mockedRule2;
    private RuleResult mockResult1;
    private RuleResult mockResult2;

    @BeforeMethod
    public void setUp() throws Exception {
        this.mockResult1 = (RuleResult)Mockito.mock(RuleResult.class);
        this.mockResult2 = (RuleResult)Mockito.mock(RuleResult.class);
        this.mockedRule1 = (Rule)Mockito.mock(Rule.class);
        this.mockedRule2 = (Rule)Mockito.mock(Rule.class);
        Mockito.when((Object)this.mockResult1.getResultCode()).thenReturn((Object)VerificationResultCode.OK);
        Mockito.when((Object)this.mockResult2.getResultCode()).thenReturn((Object)VerificationResultCode.OK);
        Mockito.when((Object)this.mockedRule1.verify((VerificationContext)Mockito.any(VerificationContext.class))).thenReturn((Object)this.mockResult1);
        Mockito.when((Object)this.mockedRule2.verify((VerificationContext)Mockito.any(VerificationContext.class))).thenReturn((Object)this.mockResult2);
    }

    @Test
    public void testCompositeRuleReturnsOkWhenAllTestsReturnOk() throws Exception {
        CompositeRule rule = new CompositeRule(false, new Rule[]{this.mockedRule1, this.mockedRule2});
        CompositeRule.CompositeRuleResult result = rule.verify(null);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testCompositeRuleReturnsFailWhenAtLeastOnRuleFails() throws Exception {
        Mockito.when((Object)this.mockResult2.getResultCode()).thenReturn((Object)VerificationResultCode.FAIL);
        CompositeRule rule = new CompositeRule(false, new Rule[]{this.mockedRule1, this.mockedRule2});
        CompositeRule.CompositeRuleResult result = rule.verify(null);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
    }

    @Test
    public void testCompositeRuleReturnsNaWhenAtLeastOnRuleReturnsNA() throws Exception {
        Mockito.when((Object)this.mockResult2.getResultCode()).thenReturn((Object)VerificationResultCode.NA);
        CompositeRule rule = new CompositeRule(false, new Rule[]{this.mockedRule1, this.mockedRule2});
        CompositeRule.CompositeRuleResult result = rule.verify(null);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
    }

    @Test
    public void testCompositeRuleReturnsOkWhenAtLeastOnRuleReturnsOk() throws Exception {
        Mockito.when((Object)this.mockResult1.getResultCode()).thenReturn((Object)VerificationResultCode.OK);
        CompositeRule rule = new CompositeRule(true, new Rule[]{this.mockedRule1, this.mockedRule2});
        CompositeRule.CompositeRuleResult result = rule.verify(null);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testCompositeRuleReturnsNaWhenAllRulesReturnNa() throws Exception {
        Mockito.when((Object)this.mockResult1.getResultCode()).thenReturn((Object)VerificationResultCode.NA);
        Mockito.when((Object)this.mockResult2.getResultCode()).thenReturn((Object)VerificationResultCode.NA);
        CompositeRule rule = new CompositeRule(true, new Rule[]{this.mockedRule1, this.mockedRule2});
        CompositeRule.CompositeRuleResult result = rule.verify(null);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
    }

    @Test
    public void testNestedCompositeRule() throws Exception {
        Mockito.when((Object)this.mockResult1.getResultCode()).thenReturn((Object)VerificationResultCode.NA);
        Mockito.when((Object)this.mockResult2.getResultCode()).thenReturn((Object)VerificationResultCode.OK);
        CompositeRule rule = new CompositeRule(true, new Rule[]{new CompositeRule(false, new Rule[]{this.mockedRule2, new CompositeRule(true, new Rule[]{new CompositeRule(false, new Rule[]{this.mockedRule2, this.mockedRule1}), new CompositeRule(false, new Rule[]{this.mockedRule2, this.mockedRule2})}), this.mockedRule2})});
        CompositeRule.CompositeRuleResult result = rule.verify(null);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }
}

