/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.DataHasher;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.DocumentHashVerificationRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DocumentHashVerificationRuleTest
extends AbstractRuleTest {
    private Rule rule = new DocumentHashVerificationRule();

    @Test
    public void testSignatureVerificationWithoutDocumentHashReturnsOkStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testSignatureVerificationWithValidDocumentHashReturnsOkStatus_Ok() throws Exception {
        DataHasher hasher = new DataHasher(HashAlgorithm.SHA2_256);
        hasher.addData(TestUtil.loadFile((String)"input-file/infile"));
        Assert.assertEquals((Object)this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), hasher.getHash())).getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testSignatureVerificationWithInvalidDocumentHashReturnsOkStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), new DataHash(HashAlgorithm.SHA2_256, new byte[32])));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_01);
    }

    @Test
    public void testSignatureVerificationWithInvalidRfc3161OutputHashReturnsFailStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig"), new DataHash(HashAlgorithm.SHA2_256, new byte[32])));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_01);
    }
}

