/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.ExtendingPermittedVerificationRule;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtendingPermittedVerificationRuleTest {
    private ExtendingPermittedVerificationRule rule = new ExtendingPermittedVerificationRule();
    private VerificationContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.context = (VerificationContext)Mockito.mock(VerificationContext.class);
    }

    @Test
    public void testExtendingIsNotAllowed_Ok() throws Exception {
        Mockito.when((Object)this.context.isExtendingAllowed()).thenReturn((Object)false);
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }

    @Test
    public void testExtendingIsAllowed_Ok() throws Exception {
        Mockito.when((Object)this.context.isExtendingAllowed()).thenReturn((Object)true);
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }
}

