/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.PublicationsFilePublicationHashMatchesExtenderResponseRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import java.util.Date;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PublicationsFilePublicationHashMatchesExtenderResponseRuleTest
extends AbstractRuleTest {
    private Rule rule = new PublicationsFilePublicationHashMatchesExtenderResponseRule();
    private VerificationContext mockedVerificationContext;

    @BeforeMethod
    public void setUp() throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        this.mockedVerificationContext = (VerificationContext)Mockito.mock(VerificationContext.class);
        Mockito.when((Object)this.mockedVerificationContext.getSignature()).thenReturn((Object)sig);
        Mockito.when((Object)this.mockedVerificationContext.getUserProvidedPublication()).thenReturn((Object)sig.getPublicationRecord().getPublicationData());
        Mockito.when((Object)this.mockedVerificationContext.getPublicationsFile()).thenReturn((Object)TestUtil.loadPublicationsFile("publications-files/publications.tlv"));
        Mockito.when((Object)this.mockedVerificationContext.getCalendarHashChain()).thenReturn((Object)sig.getCalendarHashChain());
    }

    @Test
    public void testVerifyExtendedCalendarChainInputHashMatchesWithInitialSignature_Ok() throws Exception {
        Mockito.when((Object)this.mockedVerificationContext.getExtendedCalendarHashChain((Date)Mockito.any(Date.class))).thenReturn((Object)TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig").getCalendarHashChain());
        RuleResult result = this.rule.verify(this.mockedVerificationContext);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testVerifyExtendedCalendarChainInputHashDoesNotMatchesWithInitialSignature_Ok() throws Exception {
        Mockito.when((Object)this.mockedVerificationContext.getExtendedCalendarHashChain((Date)Mockito.any(Date.class))).thenReturn((Object)TestUtil.loadSignature("signatures/ok-sig-2014-06-2-extended.ksig").getCalendarHashChain());
        RuleResult result = this.rule.verify(this.mockedVerificationContext);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.PUB_01);
    }

    @Test
    public void testVerifyThatAggregationTimeIsTakenCorrectedWay() throws Exception {
        Mockito.when((Object)this.mockedVerificationContext.getCalendarHashChain()).thenReturn(null);
        Mockito.when((Object)this.mockedVerificationContext.getExtendedCalendarHashChain((Date)Mockito.any(Date.class))).thenReturn((Object)TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig").getCalendarHashChain());
        RuleResult result = this.rule.verify(this.mockedVerificationContext);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }
}

