/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.Rfc3161InternalHashAlgorithmsDeprecatedRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Rfc3161InternalHashAlgorithmsDeprecatedRuleTest
extends AbstractRuleTest {
    private Rule rule = new Rfc3161InternalHashAlgorithmsDeprecatedRule();

    @Test
    public void testSignatureVerification_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testRfc3161SigAtrValidSha1_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/signature-SHA1-in-rfc3161-record-sig-atr-algorithm.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testRfc3161SigAtrDeprecatedSha1() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/rfc3161-record/invalid-signature-rfc3161-deprecated-algo-in-sig-attr-algo.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.INT_14);
    }

    @Test
    public void testRfc3161TstAlgorithmValidSha1_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/signature-SHA1-in-rfc3161-record-tst-info-algorithm.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testRfc3161TstAlgorithmDeprecatedSha1() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/rfc3161-record/invalid-signature-rfc3161-deprecated-algo-in-tst-info-algo.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.INT_14);
    }
}

