/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import com.guardtime.ksi.unisignature.verifier.rules.UserProvidedPublicationTimeEqualsToSignaturePublicationTimeRule;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UserProvidedPublicationTimeEqualsToSignaturePublicationTimeRuleTest
extends AbstractRuleTest {
    private Rule rule = new UserProvidedPublicationTimeEqualsToSignaturePublicationTimeRule();

    @Test
    public void testUserPublicationTimeDoesNotEqualToSignaturePublicationTime_Ok() throws Exception {
        PublicationData publication = new PublicationData(new Date(), new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig"), publication));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
    }

    @Test
    public void testUserPublicationTimeEqualToSignaturePublicationTime_Ok() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        RuleResult result = this.rule.verify(this.build(signature, signature.getPublicationRecord().getPublicationData()));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }
}

