/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi;

import com.guardtime.ksi.Extender;
import com.guardtime.ksi.ExtenderBuilder;
import com.guardtime.ksi.PublicationsHandler;
import com.guardtime.ksi.Signer;
import com.guardtime.ksi.SignerBuilder;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.KSISigningService;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExtenderBuilderTest {
    private KSIExtendingService mockedExtendingService;
    private KSISigningService mockedSigningService;
    private PublicationsHandler mockedPublicationsHandler;

    @BeforeClass
    public void setUp() throws Exception {
        this.mockedExtendingService = (KSIExtendingService)Mockito.mock(KSIExtendingService.class);
        this.mockedSigningService = (KSISigningService)Mockito.mock(KSISigningService.class);
        this.mockedPublicationsHandler = (PublicationsHandler)Mockito.mock(PublicationsHandler.class);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="KSI extending service can not be null")
    public void testExtenderBuilderWithoutExtendingService() throws KSIException {
        new ExtenderBuilder().build();
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="KSI publications handler can not be null")
    public void testExtenderBuilderWithoutPublicationsHandler() throws KSIException {
        new ExtenderBuilder().setExtendingService(this.mockedExtendingService).build();
    }

    @Test
    public void testExtenderBuilderOk() throws KSIException {
        Extender extender = new ExtenderBuilder().setExtendingService(this.mockedExtendingService).setPublicationsHandler(this.mockedPublicationsHandler).build();
        Assert.assertNotNull((Object)extender);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="KSI signing service can not be null")
    public void testSignerBuilderWithoutSigningService() throws KSIException {
        new SignerBuilder().build();
    }

    @Test
    public void testSignerBuilderOk() throws KSIException {
        Signer signer = new SignerBuilder().setSigningService(this.mockedSigningService).build();
        Assert.assertNotNull((Object)signer);
    }
}

