/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.KSIBuilder;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationRecord;
import com.guardtime.ksi.publication.inmemory.PublicationsFilePublicationRecord;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpExtenderClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpPublicationsFileClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpSigningClient;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.inmemory.InvalidSignatureContentException;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.policies.CalendarBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.DefaultVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.InternalVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.UserProvidedPublicationBasedVerificationPolicy;
import com.guardtime.ksi.util.Util;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DefaultVerificationIntegrationTest
extends AbstractCommonIntegrationTest {
    private static KSIBuilder ksiBuilder;

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
        ksiBuilder = DefaultVerificationIntegrationTest.initKsiBuilder((KSIExtenderClient)new SimpleHttpExtenderClient(DefaultVerificationIntegrationTest.loadExtenderSettings()), (KSISigningClient)new SimpleHttpSigningClient(DefaultVerificationIntegrationTest.loadSignerSettings()), (KSIPublicationsFileClient)new SimpleHttpPublicationsFileClient(DefaultVerificationIntegrationTest.loadPublicationsFileSettings()));
    }

    @Test(groups={"integration"}, expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp=".*Verification inconclusive.*")
    public void testSigningWithPublicationFileBasedVerification_InvalidSignatureContentException_GEN2() throws Exception {
        PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            try {
                ksiTest.sign(new byte[32]);
            }
            catch (InvalidSignatureContentException e) {
                Assert.assertNotNull((Object)e.getSignature(), (String)"Signature is not provided with exception.");
                Assert.assertEquals((Object)e.getVerificationResult().getErrorCode(), (Object)VerificationErrorCode.GEN_02);
                throw e;
            }
        }
    }

    @Test(groups={"integration"}, expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp=".*Calendar hash chain input hash mismatch.*")
    public void testExtendInvalidSignature_InvalidSignatureContentException_INT3() throws Exception {
        InternalVerificationPolicy policy = new InternalVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            KSISignature signature = ksiTest.read(CommonTestUtil.loadFile((String)"signatures/all-wrong-hash-chains-in-signature.ksig"));
            PublicationsFilePublicationRecord publicationRecord = new PublicationsFilePublicationRecord(new PublicationData("AAAAAA-CX5TF7-IAOXTG-6N4TGI-AIGLHG-ZD2NOX-WHGLYG-HHOXAD-XJ3FIN-GXJSGS-72NPRL-3ECEBJ"));
            try {
                ksiTest.extend(signature, (PublicationRecord)publicationRecord);
            }
            catch (InvalidSignatureContentException e) {
                Util.notNull((Object)e.getSignature(), (String)"Signature is not provided with exception.");
                Assert.assertEquals((Object)e.getVerificationResult().getErrorCode(), (Object)VerificationErrorCode.INT_03);
                throw e;
            }
        }
    }

    @Test(groups={"integration"}, expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp=".*The metadata record in the aggregation hash chain may not be trusted.*")
    public void testInternalVerificationAsDefaultPolicy_InvalidSignatureContentException_INT11() throws Exception {
        InternalVerificationPolicy policy = new InternalVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            ksiTest.read(CommonTestUtil.loadFile((String)"internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-metadata-padding-value-too-long.tlv"));
        }
    }

    @Test(groups={"integration"}, expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp=".*Signature.*is invalid: GEN_02.*")
    public void testKeyBasedVerificationAsDefaultVerificationPolicy_InvalidSignatureContentException_GEN2() throws Exception {
        KeyBasedVerificationPolicy policy = new KeyBasedVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            ksiTest.read(CommonTestUtil.loadFile((String)"policy-verification-signatures/policy-verification-signature-changed-certificate-id-GEN-02.ksig"));
        }
    }

    @Test(groups={"integration"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*Unsupported default verification policy.*")
    public void testUserProvidedPublicationBasedVerificationAsDefaultVerificationPolicy() throws Exception {
        ksiBuilder.setDefaultVerificationPolicy((Policy)new UserProvidedPublicationBasedVerificationPolicy()).build();
    }

    @Test(groups={"integration"}, expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp=".*Aggregation hash chain root hash and calendar database hash chain input hash mismatch.*")
    public void testCalendarBasedVerificationAsDefaultVerificationPolicy_InvalidSignatureContentException_CAL2() throws Exception {
        CalendarBasedVerificationPolicy policy = new CalendarBasedVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            ksiTest.read(CommonTestUtil.loadFile((String)"policy-verification-signatures/policy-verification-signature-other-core-signature.ksig"));
        }
    }

    @Test(groups={"integration"}, expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp=".*Extender response input hash mismatch.*")
    public void testPublicationFileBasedVerificationAsDefaultVerificationPolicy_InvalidSignatureContentException_PUB3() throws Exception {
        PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            ksiTest.read(CommonTestUtil.loadFile((String)"policy-verification-signatures/policy-verification-signature-other-core-signature-with-extended-calendar-PUB-03.ksig"));
        }
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyAsDefaultVerificationPolicy_OK() throws Exception {
        DefaultVerificationPolicy policy = new DefaultVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            ksiTest.read(CommonTestUtil.loadFile((String)"signatures/ok-sig-2017-03-14.ksig"));
        }
    }

    @Test(groups={"integration"}, expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp=".*Extender response input hash mismatch.*")
    public void testDefaultPolicyAsDefaultVerificationPolicy__InvalidSignatureContentException_PUB3() throws Exception {
        DefaultVerificationPolicy policy = new DefaultVerificationPolicy();
        try (KSI ksiTest = ksiBuilder.setDefaultVerificationPolicy((Policy)policy).build();){
            ksiTest.read(CommonTestUtil.loadFile((String)"policy-verification-signatures/policy-verification-signature-other-core-signature.ksig"));
        }
    }
}

