/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.InconsistentCalendarHashChainException;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationRecord;
import com.guardtime.ksi.publication.PublicationsFile;
import com.guardtime.ksi.publication.inmemory.PublicationsFilePublicationRecord;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.SignaturePublicationRecord;
import com.guardtime.ksi.unisignature.inmemory.InvalidSignatureContentException;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.UserProvidedPublicationBasedVerificationPolicy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExtendingIntegrationTest
extends AbstractCommonIntegrationTest {
    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testExtendToNearest_OK(KSI ksi) throws Exception {
        KSISignature extendedSignature = ksi.extend(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"));
        Assert.assertTrue((boolean)extendedSignature.isExtended(), (String)"Signature extension failed.");
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifyExtendedSignature_OK(KSI ksi) throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        signature = ksi.extend(signature);
        Assert.assertTrue((boolean)signature.isExtended(), (String)"Signature extension failed.");
        VerificationResult verificationResult = ksi.verify(signature, (Policy)new PublicationsFileBasedVerificationPolicy());
        Assert.assertTrue((boolean)verificationResult.isOk(), (String)("Verification of extended signature failed with " + verificationResult.getErrorCode()));
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testExtendWithPublicationsFile_OK(KSI ksi) throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        PublicationsFile publicationsFile = TestUtil.loadPublicationsFile("publications-files/publications.tlv");
        PublicationRecord publicationRecord = publicationsFile.getPublicationRecord(signature.getPublicationTime());
        KSISignature extendedSignature = ksi.extend(signature, publicationRecord);
        Assert.assertTrue((boolean)extendedSignature.isExtended());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testExtendToUserPublicationString_OK(KSI ksi) throws Exception {
        SignaturePublicationRecord publicationRecord = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig").getPublicationRecord();
        KSISignature extendedSignature = ksi.extend(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), (PublicationRecord)publicationRecord);
        Assert.assertTrue((boolean)extendedSignature.isExtended(), (String)"Signature extension failed");
        VerificationResult result = ksi.verify(extendedSignature, (Policy)new UserProvidedPublicationBasedVerificationPolicy(), publicationRecord.getPublicationData());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifyExtendedSignatureAfterWrithingToAndReadingFromStream_OK(KSI ksi) throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        signature = ksi.extend(signature);
        Assert.assertTrue((boolean)signature.isExtended(), (String)"Signature extension failed.");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        signature.writeTo((OutputStream)baos);
        signature = ksi.read((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        VerificationResult verificationResult = ksi.verify(signature, (Policy)new PublicationsFileBasedVerificationPolicy());
        Assert.assertTrue((boolean)verificationResult.isOk(), (String)("Verification of extended signature failed with " + verificationResult.getErrorCode()));
    }

    @Test(groups={"integration"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Publication is before signature")
    public void testExtendPublicationBeforeSignature_NOK() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        PublicationsFilePublicationRecord publicationRecord = new PublicationsFilePublicationRecord(new PublicationData(new Date(signature.getAggregationTime().getTime() - 1000000L), new DataHash(HashAlgorithm.SHA2_256, new byte[32])));
        this.ksi.extend(signature, (PublicationRecord)publicationRecord);
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testExtendSignatureFromAnotherCore_NOK(KSI ksi) throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        PublicationsFilePublicationRecord record = new PublicationsFilePublicationRecord(new PublicationData(new Date(signature.getPublicationTime().getTime() + 100000L), new DataHash(HashAlgorithm.SHA2_256, new byte[32])));
        try {
            ksi.extend(signature, (PublicationRecord)record);
            Assert.assertTrue((boolean)false, (String)"Extended signature internal verification had to fail.");
        }
        catch (InvalidSignatureContentException e) {
            Assert.assertFalse((boolean)e.getVerificationResult().isOk());
            Assert.assertEquals((Object)e.getVerificationResult().getErrorCode(), (Object)VerificationErrorCode.INT_09);
            Assert.assertTrue((boolean)e.getSignature().isExtended());
        }
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"}, expectedExceptions={InconsistentCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Right links of signature calendar hash chain and extended calendar hash chain do not match")
    public void testExtendSignatureWithMissingRightLinkInCalendarChain_throwsKsiException(KSI ksi) throws Exception {
        ksi.extend(TestUtil.loadSignature("signatures/signature-calendar-hash-chain-with-extra-right-link-and-shape-not-ok.ksig"));
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"}, expectedExceptions={InconsistentCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Right links of signature calendar hash chain and extended calendar hash chain do not match")
    public void testExtendSignatureWithCalendarChain_throwsKsiException(KSI ksi) throws Exception {
        ksi.extend(TestUtil.loadSignature("policy-verification-signatures/policy-verification-signature-first-right-link-is-changed-CAL-04.ksig"));
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testExtendSignatureWithCalendarChain_Ok(KSI ksi) throws Exception {
        KSISignature extendedSignature = ksi.extend(TestUtil.loadSignature("valid-signatures/signature-only-aggregation-chains.ksig"));
        Assert.assertTrue((boolean)extendedSignature.isExtended(), (String)"Signature extension failed.");
    }
}

