/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.Extender;
import com.guardtime.ksi.PublicationsHandler;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationsFile;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.KSIProtocolException;
import com.guardtime.ksi.service.client.KSIClientException;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSIServiceCredentials;
import com.guardtime.ksi.service.client.ServiceCredentials;
import com.guardtime.ksi.service.client.http.CredentialsAwareHttpSettings;
import com.guardtime.ksi.service.http.simple.SimpleHttpExtenderClient;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.PolicyVerificationResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContextBuilder;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.CalendarBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicy;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicyAdapter;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.UserProvidedPublicationBasedVerificationPolicy;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FallbackPolicyIntegrationTest
extends AbstractCommonIntegrationTest {
    @Test(groups={"integration"})
    public void testFallbackFromKeyBasedVerificationToCalendarBasedVerification_Ok() throws Exception {
        KeyBasedVerificationPolicy policy = new KeyBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new CalendarBasedVerificationPolicy());
        this.verification(TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig"), (Policy)policy, false);
    }

    @Test(groups={"integration"})
    public void testFallbackFromKeyBasedVerificationToPublicationFileBasedVerification_Ok() throws Exception {
        KeyBasedVerificationPolicy policy = new KeyBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new PublicationsFileBasedVerificationPolicy());
        this.verification(TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig"), (Policy)policy, false);
    }

    @Test(groups={"integration"})
    public void testFallbackFromKeyBasedVerificationToUserProvidedPublicationVerification_Ok() throws Exception {
        KeyBasedVerificationPolicy policy = new KeyBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new UserProvidedPublicationBasedVerificationPolicy());
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        PublicationData publicationData = signature.getPublicationRecord().getPublicationData();
        this.verificationWithPublicationData(signature, (Policy)policy, publicationData, false);
    }

    @Test(groups={"integration"})
    public void testFallbackFromPublicationFileBasedVerificationToCalendarBasedVerification_Ok() throws Exception {
        PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new CalendarBasedVerificationPolicy());
        this.verification(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), (Policy)policy, false);
    }

    @Test(groups={"integration"})
    public void testFallbackFromPublicationFileBasedVerificationToUserProvidedPublicationVerification_Ok() throws Exception {
        PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new UserProvidedPublicationBasedVerificationPolicy());
        PublicationsFile publicationFile = TestUtil.loadPublicationsFile("publications-files/publications-one-cert-one-publication-record-with-wrong-hash.tlv");
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        PublicationData publicationData = signature.getPublicationRecord().getPublicationData();
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setExtenderClient((KSIExtenderClient)this.extenderClient).setPublicationsFile(publicationFile);
        builder.setUserPublication(publicationData);
        builder.setExtendingAllowed(false);
        Assert.assertTrue((boolean)this.ksi.verify(builder.build(), (Policy)policy).isOk());
    }

    @Test(groups={"integration"})
    public void testFallbackFromPublicationFileBasedVerificationToKeyBasedVerification_Ok() throws Exception {
        PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new KeyBasedVerificationPolicy());
        this.verification(TestUtil.loadSignature("signatures/ok-sig-2021-11-04.ksig"), (Policy)policy, false);
    }

    @Test(groups={"integration"})
    public void testFallbackFromUserProvidedPublicationVerificationToCalendarBasedVerification_Ok() throws Exception {
        UserProvidedPublicationBasedVerificationPolicy policy = new UserProvidedPublicationBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new CalendarBasedVerificationPolicy());
        PublicationData publicationData = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig").getPublicationRecord().getPublicationData();
        this.verificationWithPublicationData(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), (Policy)policy, publicationData, false);
    }

    @Test(groups={"integration"})
    public void testFallbackFromUserProvidedPublicationVerificationToPublicationFileBasedVerification_Ok() throws Exception {
        UserProvidedPublicationBasedVerificationPolicy policy = new UserProvidedPublicationBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new PublicationsFileBasedVerificationPolicy());
        PublicationData publicationData = new PublicationData("AAAAAA-CS2XHY-AAJCBE-DDAFMR-R3RKMY-GMAQDZ-FSAE7B-ZO64CT-QPNC3B-RQ6UGY-67QORK-6STDTS");
        this.verificationWithPublicationData(TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig"), (Policy)policy, publicationData, false);
    }

    @Test(groups={"integration"})
    public void testFallbackFromUserProvidedPublicationVerificationToKeyBasedVerification_Ok() throws Exception {
        UserProvidedPublicationBasedVerificationPolicy policy = new UserProvidedPublicationBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)new KeyBasedVerificationPolicy());
        PublicationData publicationData = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig").getPublicationRecord().getPublicationData();
        this.verificationWithPublicationData(TestUtil.loadSignature("signatures/ok-sig-2021-11-04.ksig"), (Policy)policy, publicationData, false);
    }

    @Test(groups={"integration"})
    public void testFallBackFromUserPublicationAndPublicationFileToKeyBasedPolicy_Ok() throws Exception {
        UserProvidedPublicationBasedVerificationPolicy policy = new UserProvidedPublicationBasedVerificationPolicy();
        PublicationsFileBasedVerificationPolicy fallbackPolicy = new PublicationsFileBasedVerificationPolicy();
        fallbackPolicy.setFallbackPolicy((Policy)new KeyBasedVerificationPolicy());
        policy.setFallbackPolicy((Policy)fallbackPolicy);
        PublicationData publicationData = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig").getPublicationRecord().getPublicationData();
        this.verificationWithPublicationData(TestUtil.loadSignature("signatures/ok-sig-2021-11-04.ksig"), (Policy)policy, publicationData, false);
    }

    @Test(groups={"integration"})
    public void testFallBackFromPublicationFileAndKeyBasedToCalendarPolicy_Ok() throws Exception {
        PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();
        KeyBasedVerificationPolicy fallback_policy = new KeyBasedVerificationPolicy();
        fallback_policy.setFallbackPolicy((Policy)new CalendarBasedVerificationPolicy());
        policy.setFallbackPolicy((Policy)fallback_policy);
        PublicationData publicationData = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig").getPublicationRecord().getPublicationData();
        this.verificationWithPublicationData(TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig"), (Policy)policy, publicationData, false);
    }

    @Test(groups={"integration"})
    public void testFallBackFromCalendarBasedPolicyToKeyBasedPolicyWithInvalidExtenderCredentials_Ok() throws Exception {
        CalendarBasedVerificationPolicy policy = new CalendarBasedVerificationPolicy();
        KeyBasedVerificationPolicy fallbackPolicy = new KeyBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)fallbackPolicy);
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2021-11-04.ksig");
        SimpleHttpExtenderClient extClient = new SimpleHttpExtenderClient(new CredentialsAwareHttpSettings(FallbackPolicyIntegrationTest.loadExtenderSettings().getUrl().toString(), (ServiceCredentials)new KSIServiceCredentials("rand", "omnom")));
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)extClient, signature, (Policy)policy, null, true);
        this.checkFallBackVerificationResultWithException(result, true, 2, KSIProtocolException.class);
    }

    @Test(groups={"integration"})
    public void testFallBackFromCalendarBasedPolicyToKeyBasedPolicyWithInvalidExtenderUrl_Ok() throws Exception {
        CalendarBasedVerificationPolicy policy = new CalendarBasedVerificationPolicy();
        KeyBasedVerificationPolicy fallbackPolicy = new KeyBasedVerificationPolicy();
        policy.setFallbackPolicy((Policy)fallbackPolicy);
        KSISignature signature = this.ksi.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        SimpleHttpExtenderClient randomClient = new SimpleHttpExtenderClient(new CredentialsAwareHttpSettings("http://some.random.url.abc", (ServiceCredentials)new KSIServiceCredentials("rand", "omnom")));
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)randomClient, signature, (Policy)policy, null, true);
        this.checkFallBackVerificationResultWithException(result, true, 2, KSIClientException.class);
    }

    @Test(groups={"integration"})
    public void testVerifierCreatesNewContextInCaseOfUsesContextAwarePolicy_Ok() throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createKeyPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient));
        policy.setFallbackPolicy((Policy)ContextAwarePolicyAdapter.createCalendarPolicy((Extender)this.getExtender(this.ksi.getExtendingService(), (KSIPublicationsFileClient)this.publicationsFileClient)));
        VerificationResult result = this.ksi.verify(sig, policy);
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyContextAwarePolicyAndPolicyFallbackMix_Ok() throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2014-06-2-only-aggr-chains.ksig");
        KeyBasedVerificationPolicy policy = new KeyBasedVerificationPolicy();
        ContextAwarePolicy fallbackPolicy = ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)new PublicationData("AAAAAA-C4RLVQ-AANBBO-5WLN2O-WONO5N-RKF5UD-RBOWLI-44YWTZ-MV4NT6-MSNYQR-LM6PTB-ROGDPE"));
        fallbackPolicy.setFallbackPolicy((Policy)ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)new PublicationData("AAAAAA-C4RLVQ-AANBBO-5WLN2O-WONO5N-RKF5UD-RBOWLI-44YWTZ-MV4NT6-MSNYQR-LM6PTB-ROGDPE"), (Extender)this.getExtender(this.ksi.getExtendingService(), (KSIPublicationsFileClient)this.publicationsFileClient)));
        policy.setFallbackPolicy((Policy)fallbackPolicy);
        ContextAwarePolicy contextAwarePolicy = ContextAwarePolicyAdapter.createPolicy((Policy)policy, (PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), (KSIExtendingService)this.ksi.getExtendingService());
        VerificationResult result = this.ksi.verify(sig, contextAwarePolicy);
        Assert.assertEquals((int)result.getPolicyVerificationResults().size(), (int)3);
        Assert.assertTrue((boolean)result.isOk());
    }

    private void checkFallBackVerificationResultWithException(VerificationResult result, boolean resultIsOk, int policyResultsSize, Class expectedExceptionClass) {
        Assert.assertEquals((boolean)result.isOk(), (boolean)resultIsOk);
        List policyResults = result.getPolicyVerificationResults();
        Assert.assertEquals((int)policyResults.size(), (int)policyResultsSize);
        PolicyVerificationResult policyVerificationResult = this.getCalendarPolicyVerificationResult(policyResults);
        Assert.assertNotNull((Object)policyVerificationResult);
        Assert.assertNotNull((Object)policyVerificationResult.getException());
        Assert.assertEquals(policyVerificationResult.getException().getClass(), (Object)expectedExceptionClass);
    }

    private PolicyVerificationResult getCalendarPolicyVerificationResult(List<PolicyVerificationResult> policyResults) {
        for (PolicyVerificationResult policyResult : policyResults) {
            if (!(policyResult.getPolicy() instanceof CalendarBasedVerificationPolicy)) continue;
            return policyResult;
        }
        return null;
    }

    private void verification(KSISignature signature, Policy policy, boolean enableExtender) throws Exception {
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, policy, enableExtender);
        Assert.assertTrue((boolean)result.isOk());
    }

    private void verificationWithPublicationData(KSISignature signature, Policy policy, PublicationData publicationData, boolean enableExtender) throws Exception {
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, policy, publicationData, enableExtender);
        Assert.assertTrue((boolean)result.isOk());
    }
}

