/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.unisignature.verifier.AlwaysSuccessfulPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.CalendarBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.DefaultVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.InternalVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.UserProvidedPublicationBasedVerificationPolicy;

public enum IntegrationTestAction {
    FAIL_AT_PARSING("parsing", new AlwaysSuccessfulPolicy()),
    NOT_IMPLEMENTED("not-implemented", new AlwaysSuccessfulPolicy()),
    POLICY_INTERNAL("internal", (Policy)new InternalVerificationPolicy()),
    POLICY_KEY("key", (Policy)new KeyBasedVerificationPolicy()),
    POLICY_CALENDAR("calendar", (Policy)new CalendarBasedVerificationPolicy()),
    POLICY_USER_PUBLICATION("userPublication", (Policy)new UserProvidedPublicationBasedVerificationPolicy()),
    POLICY_PUBLICATIONS_FILE("publicationsFile", (Policy)new PublicationsFileBasedVerificationPolicy()),
    POLICY_DEFAULT("default", (Policy)new DefaultVerificationPolicy());

    private final String name;
    private final Policy policy;

    private IntegrationTestAction(String name, Policy policy) {
        this.name = name;
        this.policy = policy;
    }

    public String getName() {
        return this.name;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public static IntegrationTestAction getByName(String name) {
        for (IntegrationTestAction action : IntegrationTestAction.values()) {
            if (!action.getName().equals(name)) continue;
            return action;
        }
        throw new IllegalArgumentException("Invalid action '" + name + "'.");
    }

    public String toString() {
        return "Action={ Name=" + this.getName() + ", Policy=" + this.getPolicy().toString() + " }";
    }
}

