/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationRecord;
import com.guardtime.ksi.publication.inmemory.PublicationsFilePublicationRecord;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import com.guardtime.ksi.util.Base16;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KSIIntegrationTest
extends AbstractCommonIntegrationTest {
    @Test
    public void testReadUniSignatureFromFile_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.loadFile((String)"signatures/ok-sig-2017-03-14.ksig"));
        Assert.assertNotNull((Object)signature);
    }

    @Test
    public void testReadUniSignatureFromByteArray_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.loadBytes("signatures/ok-sig-2017-03-14.ksig"));
        Assert.assertNotNull((Object)signature);
    }

    @Test
    public void testReadUniSignatureFromInputStream_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig"));
        Assert.assertNotNull((Object)signature);
    }

    @Test
    public void testWriteUniSignatureToOutputStream_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig"));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        signature.writeTo((OutputStream)output);
        Assert.assertEquals((Object)signature, (Object)this.ksi.read(output.toByteArray()));
    }

    @Test
    public void testVerifySignatureWithoutContext_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.load((String)"signatures/ok-sig-2021-11-04.ksig"));
        VerificationResult result = this.ksi.verify(signature, (Policy)new KeyBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test
    public void testVerifySignatureWithFileDataHashWithoutContext_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.load((String)"signatures/ok-sig-2021-11-04.ksig"));
        VerificationResult result = this.ksi.verify(signature, (Policy)new KeyBasedVerificationPolicy(), new DataHash(HashAlgorithm.SHA2_256, Base16.decode((String)"D0A6D6D2EAF67A13852A4D0F48107B1DDBC35901ADC90F60CB4763054602D5B3")));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test
    public void testVerifyExtendedSignatureWithoutContext_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.load((String)"signatures/ok-sig-2017-03-14-extended.ksig"));
        VerificationResult result = this.ksi.verify(signature, (Policy)new PublicationsFileBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test
    public void testVerifyExtendedSignatureWithFileHashAndPublicationDataAndWithoutContext_OK() throws Exception {
        KSISignature signature = this.ksi.read(TestUtil.load((String)"signatures/ok-sig-2017-03-14-extended.ksig"));
        DataHash documentHash = new DataHash(HashAlgorithm.SHA2_256, Base16.decode((String)"11A700B0C8066C47ECBA05ED37BC14DCADB238552D86C659342D1D7E87B8772D"));
        VerificationResult result = this.ksi.verify(signature, (Policy)new PublicationsFileBasedVerificationPolicy(), documentHash);
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="No suitable publication yet")
    public void testExtendingSignatureWithoutAvailablePublicationRecord_ThrowsKSIException() throws Exception {
        KSISignature signature = this.ksi.sign("Random Text That Will Be Signed".getBytes());
        this.ksi.extend(signature);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Publication is before signature")
    public void testExtendingSignatureWithOlderPublicationRecord_ThrowsKSIException() throws Exception {
        KSISignature signature = this.ksi.sign("Random Text That Will Be Signed".getBytes());
        PublicationData publicationData = new PublicationData(new Date(1410739200000L), new DataHash(HashAlgorithm.SHA2_256, Base16.decode((String)"C1679EDC2E2A23D1BA9B4F49845C7607AEEF48AD1A344A1572A70907A86FF040")));
        PublicationsFilePublicationRecord publicationRecord = new PublicationsFilePublicationRecord(publicationData);
        this.ksi.extend(signature, (PublicationRecord)publicationRecord);
    }
}

