/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.inmemory.InMemoryPublicationsFileFactory;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.trust.CryptoException;
import com.guardtime.ksi.trust.PKITrustStore;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationContextBuilder;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.Store;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PublicationsFileBasedVerificationPolicyIntegrationTest
extends AbstractCommonIntegrationTest {
    private final PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();

    @Test(groups={"integration"})
    public void testVerifyExtendedSignatureWithCorrectDataAndSuitablePublicationInPublicationFile_VerificationReturnsOK() throws Exception {
        VerificationResult results = this.publicationFileBasedVerification("signatures/ok-sig-2017-03-14-extended.ksig", null, false, (KSIExtenderClient)this.extenderClient);
        Assert.assertTrue((boolean)results.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyUnextendedSignatureWithCorrectDataExtendingAllowed_VerificationReturnsOk() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, (Policy)this.policy, true);
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyUnextendedSignatureWithCorrectDataExtendingNotAllowed_VerificationReturnsGen2() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, (Policy)this.policy, false);
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }

    @Test(groups={"integration"})
    public void testVerifyExtendedSignatureWithCorrectDataExtendingAllowed_OK() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, (Policy)this.policy, true);
        Assert.assertTrue((boolean)result.isOk());
    }

    private VerificationResult publicationFileBasedVerification(String signatureFile, String publicationFile, boolean extendingAllowed, KSIExtenderClient extenderClient) throws Exception {
        KSISignature signature = TestUtil.loadSignature(signatureFile);
        VerificationContextBuilder build = new VerificationContextBuilder();
        if (publicationFile != null) {
            build.setPublicationsFile(new InMemoryPublicationsFileFactory(new PKITrustStore(){

                public boolean isTrusted(X509Certificate certificate, Store certStore) throws CryptoException {
                    return true;
                }
            }).create(CommonTestUtil.load((String)publicationFile)));
        } else {
            build.setPublicationsFile(this.ksi.getPublicationsFile());
        }
        build.setSignature(signature).setExtenderClient(extenderClient);
        build.setExtendingAllowed(extendingAllowed);
        return this.ksi.verify(build.build(), (Policy)this.policy);
    }
}

