/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.integration.IntegrationTestFailureException;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.KSIProtocolException;
import com.guardtime.ksi.tlv.MultipleTLVElementException;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.PolicyVerificationResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.CalendarBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TlvParserIntegrationTest
extends AbstractCommonIntegrationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlvParserIntegrationTest.class);
    private final Policy policy = new CalendarBasedVerificationPolicy();

    @Test(groups={"integration"})
    public void testVerifySignatureWithNonCriticalElementInExtenderResponse() throws Exception {
        String testFile = "extender-responses/extended-calendar-for-ok-sig-2014-06-2-extra-element.tlv";
        LOGGER.info("Used response file: " + testFile);
        KSIExtendingService mockedExtendingService = this.mockExtenderResponseCalendarHashCain(testFile);
        KSISignature signature = this.ksi.read(CommonTestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig"));
        VerificationResult result = this.verify(this.ksi, mockedExtendingService, signature, this.policy);
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.CAL_04);
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithUnknownCriticalElementInExtenderResponse() throws Exception {
        String exceptionMessage = "parse response message";
        Class<KSIProtocolException> exceptionClass = KSIProtocolException.class;
        this.testExtenderResponses("extender-responses/extended-calendar-for-ok-sig-2014-06-2-extra-critical-element.tlv", exceptionClass, exceptionMessage, true);
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithExtraCriticalPduInExtenderResponse() throws Exception {
        String exceptionMessage = "Message outermost layer consists of more than one TLV elements.";
        Class<MultipleTLVElementException> exceptionClass = MultipleTLVElementException.class;
        this.testExtenderResponses("extender-responses/extended-calendar-for-ok-sig-2014-06-2-extra-critical-main-with-critical-tlv.tlv", exceptionClass, exceptionMessage, false);
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithExtraCriticalPduWithNonCriticalElementsInExtenderResponse() throws Exception {
        String exceptionMessage = "Message outermost layer consists of more than one TLV elements.";
        Class<MultipleTLVElementException> exceptionClass = MultipleTLVElementException.class;
        this.testExtenderResponses("extender-responses/extended-calendar-for-ok-sig-2014-06-2-extra-critical-main-with-non-critical-tlv.tlv", exceptionClass, exceptionMessage, false);
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithExtraNonCiriticalCriticalPduInExtenderResponse() throws Exception {
        String exceptionMessage = "Message outermost layer consists of more than one TLV elements.";
        Class<MultipleTLVElementException> exceptionClass = MultipleTLVElementException.class;
        this.testExtenderResponses("extender-responses/extended-calendar-for-ok-sig-2014-06-2-extra-main-with-critical-tlv.tlv", exceptionClass, exceptionMessage, false);
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithExtraNonCriticalPduWithNonCriticalElementsInExtenderResponse() throws Exception {
        String exceptionMessage = "Message outermost layer consists of more than one TLV elements.";
        Class<MultipleTLVElementException> exceptionClass = MultipleTLVElementException.class;
        this.testExtenderResponses("extender-responses/extended-calendar-for-ok-sig-2014-06-2-extra-main-with-non-critical-tlv.tlv", exceptionClass, exceptionMessage, false);
    }

    private void testExtenderResponses(String testFile, Class exceptionClass, String message, boolean checkVerificationError) throws Exception {
        try {
            LOGGER.info("Used response file: " + testFile);
            KSIExtendingService mockedExtenderClient = this.mockExtenderResponseCalendarHashCain(testFile);
            KSISignature signature = this.ksi.read(CommonTestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig"));
            VerificationResult result = this.verify(this.ksi, mockedExtenderClient, signature, this.policy);
            if (checkVerificationError) {
                List results = result.getPolicyVerificationResults();
                for (PolicyVerificationResult r : results) {
                    if (r.getException() == null) continue;
                    throw r.getException();
                }
            }
            throw new IntegrationTestFailureException("No exception was thrown when verifying signatures/ok-sig-2017-03-14.ksig with extender response " + testFile);
        }
        catch (IntegrationTestFailureException e) {
            throw e;
        }
        catch (Exception e) {
            if (!e.getClass().isAssignableFrom(exceptionClass)) {
                throw new IntegrationTestFailureException("Expected exception " + exceptionClass.toString() + " but received " + e.getClass().toString());
            }
            if (!e.getMessage().contains(message)) {
                throw new IntegrationTestFailureException("Expected exception message '" + message + "' was not found int " + e.getMessage());
            }
            return;
        }
    }
}

