/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.publication.adapter;

import com.guardtime.ksi.publication.PublicationsFileFactory;
import com.guardtime.ksi.publication.adapter.AbstractPublicationsFileClientAdapterTest;
import com.guardtime.ksi.publication.adapter.CachingPublicationsFileClientAdapter;
import com.guardtime.ksi.publication.inmemory.InMemoryPublicationsFileFactory;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CachingPublicationsFileClientAdapterTest
extends AbstractPublicationsFileClientAdapterTest {
    private static final long CACHE_EXPIRATION_TIME = 2000L;
    private CachingPublicationsFileClientAdapter adapter;

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.adapter = new CachingPublicationsFileClientAdapter(this.mockedPublicationsFileClient, (PublicationsFileFactory)new InMemoryPublicationsFileFactory(this.mockedTrustStore), 2000L);
    }

    @Test
    public void tesCachingPublicationsFileAdapterReturnsPublicationFile() throws Exception {
        AssertJUnit.assertNotNull((Object)this.adapter.getPublicationsFile());
    }

    @Test
    public void testCachingPublicationsFileAdapterCachesRequest() throws Exception {
        this.adapter.getPublicationsFile();
        this.adapter.getPublicationsFile();
        ((KSIPublicationsFileClient)Mockito.verify((Object)this.mockedPublicationsFileClient, (VerificationMode)VerificationModeFactory.times((int)1))).getPublicationsFile();
    }

    @Test
    public void testCachingPublicationsFileAdapterUpdatesCache() throws Exception {
        CachingPublicationsFileClientAdapter spy = (CachingPublicationsFileClientAdapter)Mockito.spy((Object)this.adapter);
        ((CachingPublicationsFileClientAdapter)Mockito.doReturn((Object)true).doReturn((Object)false).doReturn((Object)true).when((Object)spy)).isCacheUpdateNeeded();
        spy.getPublicationsFile();
        spy.getPublicationsFile();
        spy.getPublicationsFile();
        ((KSIPublicationsFileClient)Mockito.verify((Object)this.mockedPublicationsFileClient, (VerificationMode)VerificationModeFactory.times((int)2))).getPublicationsFile();
    }
}

