/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.publication.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.publication.inmemory.InMemoryCertificateRecord;
import com.guardtime.ksi.publication.inmemory.InvalidPublicationsFileException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InMemoryCertificateRecordTest {
    @Test
    public void testDecodeCertificateRecord_Ok() throws Exception {
        InMemoryCertificateRecord certificateRecord = this.load("components/certificate-record/certificate-record-ok.tlv");
        Assert.assertNotNull((Object)certificateRecord.getCertificate());
        Assert.assertNotNull((Object)certificateRecord.getCertificateId());
        Assert.assertEquals((byte[])certificateRecord.getCertificateId(), (byte[])new byte[]{1, 2, 3, 4});
        Assert.assertEquals((byte[])certificateRecord.getCertificate(), (byte[])new byte[]{1, 1, 1, 1});
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Certificate Id can not be null")
    public void testDecodeCertificateRecordWithoutCertificateId_ThrowsInvalidPublicationsFileException() throws Exception {
        this.load("components/certificate-record/certificate-record-missing-certificate-id.tlv");
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Certificate can not be null")
    public void testDecodeCertificateRecordWithoutCertificate_ThrowsInvalidPublicationsFileException() throws Exception {
        this.load("components/certificate-record/certificate-record-missing-certificate.tlv");
    }

    private InMemoryCertificateRecord load(String file) throws Exception {
        return new InMemoryCertificateRecord(CommonTestUtil.loadTlv((String)file));
    }
}

