/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.publication.inmemory;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.inmemory.CertificateNotFoundException;
import com.guardtime.ksi.publication.inmemory.InMemoryPublicationsFile;
import com.guardtime.ksi.publication.inmemory.InvalidPublicationsFileException;
import com.guardtime.ksi.tlv.TLVParserException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InMemoryPublicationsFileTest {
    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="InputStream can not be null when creating publications file")
    public void testCreatePublicationsFileUsingInvalidInputStream_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(null);
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Invalid publications file magic bytes")
    public void testCreatePublicationsFileUsingInvalidMagicBytes_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile((InputStream)new ByteArrayInputStream(new byte[]{75, 83, 73, 80, 85, 66, 76, 71}));
    }

    @Test
    public void testCreatePublicationsFile_Ok() throws Exception {
        InMemoryPublicationsFile publication = new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications.tlv"));
        Assert.assertNotNull((Object)publication.getVersion());
        Assert.assertNotNull((Object)publication.getCreationTime());
        Assert.assertNull((Object)publication.getRepositoryUri());
        Assert.assertNotNull((Object)publication.getPublicationRecords());
        Assert.assertFalse((boolean)publication.getPublicationRecords().isEmpty());
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp=".*Publications file header is missing")
    public void testCreatePublicationsFileWithoutHeader_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications-file-header-missing.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp=".*Publications file CMS signature is missing")
    public void testCreatePublicationsFileWithoutCmsSignature_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications-file-signature-missing.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp=".*Publications file order is incorrect")
    public void testCreatePublicationsFileWithIncorrectElementOrder_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications-file-reordered.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp=".*Publications file order is incorrect")
    public void testCreatePublicationsFileWithElementAfterSignature_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications-file-reference-after-signature.tlv"));
    }

    @Test
    public void testCreatePublicationsFileWithoutCertificateAndPublicationRecords_Ok() throws Exception {
        InMemoryPublicationsFile publicationFile = new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications-file-cert-and-pub-records-missing.tlv"));
        Assert.assertNotNull((Object)publicationFile);
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Invalid publications file element type=0x2")
    public void testCreatePublicationsFileWithUnknownElement_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications-file-contains-unknown-element.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Invalid publications file element type=0x2")
    public void testCreatePublicationsFileWithCriticalUnknownElement_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications-file-contains-critical-unknown-element.tlv"));
    }

    @Test
    public void testGetCertificateFromPublicationsFile_Ok() throws Exception {
        InMemoryPublicationsFile publication = new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications.tlv"));
        Assert.assertNotNull((Object)publication.findCertificateById(new byte[]{-102, 101, -126, -108}));
    }

    @Test(expectedExceptions={CertificateNotFoundException.class}, expectedExceptionsMessageRegExp="Certificate with id AAAAAAAAAAAAAAAAAAAAAAAAAA== not found from pubFile=.*")
    public void testGetUnknownCertificateFromPublicationsFile_ThrowsCertificateNotFoundException() throws Exception {
        InMemoryPublicationsFile publication = new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications.tlv"));
        publication.findCertificateById(new byte[19]);
    }

    @Test(expectedExceptions={CertificateNotFoundException.class}, expectedExceptionsMessageRegExp="Certificate with id null not found from pubFile=.*")
    public void testGetCertificateFromPublicationsFileUsingInvalidCertificateId_ThrowsCertificateNotFoundException() throws Exception {
        InMemoryPublicationsFile publication = new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications.tlv"));
        publication.findCertificateById(null);
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Publications file contains multiple header components")
    public void testDecodePublicationsFileWithTwoHeaders_ThrowsInvalidPublicationsFileException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publication-one-cert-one-record-multi-header.tlv"));
    }

    @Test(expectedExceptions={TLVParserException.class}, expectedExceptionsMessageRegExp="Invalid DataHash content")
    public void testDecodePublicationsFileWithInvalidHashLength_ThrowsTLVParserException() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publication-one-cert-one-record-invalid-hash-length.tlv"));
    }

    @Test
    public void testVerifyThatActualLatestPublicationRecordIsFound_OK() throws Exception {
        InMemoryPublicationsFile publication = new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publications.tlv"));
        PublicationData latest = publication.getLatestPublication().getPublicationData();
        Assert.assertEquals((Object)latest, (Object)publication.getPublicationRecord(new Date(latest.getPublicationTime().getTime() - 100000L)).getPublicationData());
        Assert.assertNull((Object)publication.getPublicationRecord(new Date(latest.getPublicationTime().getTime() + 1000L)));
    }

    @Test(expectedExceptions={TLVParserException.class}, expectedExceptionsMessageRegExp="Unknown critical TLV element with tag=0x1 encountered")
    public void testDecodePublicationsFileWithUnknownCriticalElementInRecord() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-critical-element-in-publication-record-lvl1.tlv"));
    }

    @Test(expectedExceptions={TLVParserException.class}, expectedExceptionsMessageRegExp="Unknown critical TLV element with tag=0x5 encountered")
    public void testDecodePublicationsFileWithUnknownCriticalElementInRecord2() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-critical-element-in-publication-record-lvl2.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Invalid publications file element type=0x708")
    public void testDecodePublicationsFileWithUnknownCriticalNestedTlv() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-critical-nested-tlv-in-main.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Invalid publications file element type=0x708")
    public void testDecodePublicationsFileWithUnknownCriticalNestedTlvWithNonCriticalChild() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-critical-nested-tlv-in-main-with-non-critical-tlvs.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Invalid publications file element type=0x708")
    public void testDecodePublicationsFileWithUnknownNonCriticalElementInMain() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-non-critical-nested-tlv-in-main.tlv"));
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Invalid publications file element type=0x708")
    public void testDecodePublicationsFileWithNonCriticalNestedTlvWithCriticalChild() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-non-critical-nested-tlv-in-main-with-critical-tlvs.tlv"));
    }

    @Test(expectedExceptions={TLVParserException.class}, expectedExceptionsMessageRegExp="Unknown critical TLV element with tag=0x5 encountered")
    public void testDecodePublicationsFileWithCriticalElementInCertificateRecord() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-critical-element-in-certificate-record-lvl1.tlv"));
    }

    @Test(expectedExceptions={TLVParserException.class}, expectedExceptionsMessageRegExp="Unknown critical TLV element with tag=0x5 encountered")
    public void testDecodePublicationsFileWithCriticalElementInPublicationHeader() throws Exception {
        new InMemoryPublicationsFile(TestUtil.load((String)"publications-files/publicartions-new-critical-element-in-publication-header-lvl1.tlv"));
    }
}

