/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.publication.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.publication.inmemory.InvalidPublicationsFileException;
import com.guardtime.ksi.publication.inmemory.PublicationsFileHeader;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PublicationsFileHeaderTest {
    @Test
    public void testDecodePublicationFileHeader_Ok() throws Exception {
        PublicationsFileHeader header = this.load("publications-files/publications-file-header-ok.tlv");
        Assert.assertEquals((long)header.getVersion(), (long)2L);
        Assert.assertEquals((Object)header.getCreationTime(), (Object)new Date(123456000L));
        Assert.assertEquals((String)header.getRepositoryUri(), (String)"repository");
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Publications file header version element must be present")
    public void testDecodePublicationsFileHeaderWithoutVersion_ThrowsInvalidPublicationsFileException() throws Exception {
        this.load("publications-files/publications-file-header-version-missing.tlv");
    }

    @Test(expectedExceptions={InvalidPublicationsFileException.class}, expectedExceptionsMessageRegExp="Publications file header creation time element must be present")
    public void testDecodePublicationFileHeaderWithoutCreationTime_ThrowsInvalidPublicationsFileException() throws Exception {
        this.load("publications-files/publications-file-header-creation-time-missing.tlv");
    }

    private PublicationsFileHeader load(String file) throws Exception {
        return new PublicationsFileHeader(CommonTestUtil.loadTlv((String)file));
    }
}

