/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.trust;

import com.guardtime.ksi.trust.CMSSignature;
import com.guardtime.ksi.trust.InvalidCmsSignatureException;
import org.testng.annotations.Test;

public class CMSSignatureTest {
    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="CMS signature signed data is null or empty array")
    public void testCreateCMSSignatureWithoutSignedData_ThrowsInvalidCmsSignatureException() throws Exception {
        new CMSSignature(null, new byte[0]);
    }

    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="CMS signature signed data is null or empty array")
    public void testCreateCMSSignatureWithEmptySignedData_ThrowsInvalidCmsSignatureException() throws Exception {
        new CMSSignature(new byte[0], new byte[0]);
    }

    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="CMS signature is null or empty array")
    public void testCreateCMSSignatureWithEmptySignatureData_ThrowsInvalidCmsSignatureException() throws Exception {
        new CMSSignature(new byte[1], new byte[0]);
    }

    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="CMS signature is null or empty array")
    public void testCreateCMSSignatureWithoutCmsSignatureData_ThrowsInvalidCmsSignatureException() throws Exception {
        new CMSSignature(new byte[1], null);
    }

    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="Invalid CMS signature")
    public void testCreateCMSSignatureWithInvalidData_ThrowsInvalidCmsSignatureException() throws Exception {
        new CMSSignature(new byte[32], new byte[128]);
    }
}

