/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.unisignature.AggregationHashChain;
import com.guardtime.ksi.unisignature.AggregationHashChainUtil;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureComponentFactory;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AggregationHashChainUtilTest {
    private InMemoryKsiSignatureComponentFactory signatureComponentFactory;

    @BeforeMethod
    public void setUp() {
        this.signatureComponentFactory = new InMemoryKsiSignatureComponentFactory();
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Aggregation chain links can not be null")
    public void testCalculateAggregationHashChainIndex_nullChain_throwsNullPointerException() {
        AggregationHashChainUtil.calculateIndex(null);
    }

    @Test
    public void testCalculateIndexWithChainHeight1_Ok() throws Exception {
        AggregationHashChain chain = this.signatureComponentFactory.createAggregationHashChain(CommonTestUtil.loadTlv((String)"components/aggregation-hash-chain/aggregation-hash-chain-with-left-link-and-height-1.tlv"));
        Assert.assertEquals((long)AggregationHashChainUtil.calculateIndex((List)chain.getChainLinks()), (long)3L);
    }

    @Test
    public void testCalculateIndexWithChainHeight3_Ok() throws Exception {
        AggregationHashChain chain = this.signatureComponentFactory.createAggregationHashChain(CommonTestUtil.loadTlv((String)"components/aggregation-hash-chain/aggregation-hash-chain-with-height-3.tlv"));
        Assert.assertEquals((long)AggregationHashChainUtil.calculateIndex((List)chain.getChainLinks()), (long)15L);
    }
}

