/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.unisignature.ChainResult;
import com.guardtime.ksi.unisignature.Identity;
import com.guardtime.ksi.unisignature.IdentityType;
import com.guardtime.ksi.unisignature.inmemory.InMemoryAggregationHashChain;
import com.guardtime.ksi.unisignature.inmemory.InvalidAggregationHashChainException;
import com.guardtime.ksi.util.Base16;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AggregationHashChainTest {
    @Test
    public void testDecodeAggregationHashChain_Ok() throws Exception {
        InMemoryAggregationHashChain chain = this.load("signatures/single-long-aggregation-hash-chain-ok.tlv");
        Assert.assertEquals((int)chain.getElementType(), (int)2049);
        Assert.assertNotNull((Object)chain.getAggregationTime());
        Assert.assertEquals((long)chain.getAggregationTime().getTime(), (long)1395317319000L);
        Identity[] identities = chain.getIdentity();
        Assert.assertEquals((int)identities.length, (int)4);
        Assert.assertEquals((String)identities[0].getDecodedClientId(), (String)"GT");
        Assert.assertEquals((Object)identities[0].getType(), (Object)IdentityType.LEGACY);
        Assert.assertEquals((Object)identities[identities.length - 1].getType(), (Object)IdentityType.METADATA);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Aggregation time can not be null")
    public void testDecodeAggregationHashChainWithoutAggregationTime_ThrowsInvalidAggregationHashChainException() throws Exception {
        this.load("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-aggr-time-missing-tag.tlv");
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Aggregation chain index list can not be empty")
    public void testDecodeAggregationHashChainWithoutChainIndex_ThrowsInvalidAggregationHashChainException() throws Exception {
        this.load("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-chain-index-missing-tag.tlv");
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Aggregation chain input hash can not be empty")
    public void testDecodeAggregationHashChainWithoutInputHash_ThrowsInvalidAggregationHashChainException() throws Exception {
        this.load("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-input-hash-missing-tag.tlv");
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Aggregation chain aggregation algorithm id can no be null")
    public void testDecodeAggregationHashChainWithoutAggregationAlgorithm_ThrowsInvalidAggregationHashChainException() throws Exception {
        this.load("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-aggr-algo-missing-tag.tlv");
    }

    @Test
    public void testCalculateAggregationChainHash_Ok() throws Exception {
        InMemoryAggregationHashChain chain = this.load("signatures/single-long-aggregation-hash-chain-ok.tlv");
        ChainResult chainHash = chain.calculateOutputHash(0L);
        Assert.assertNotNull((Object)chainHash);
        Assert.assertEquals((long)chainHash.getLevel(), (long)116L);
        Assert.assertEquals((byte[])chainHash.getOutputHash().getImprint(), (byte[])Base16.decode((String)"01C3EE66A55C8E277D4652549AE076EB22596AB9F56BB0775C62E2E02837A7FDFF"));
    }

    @Test
    public void testGetChainIdentityFromAggregationHashChain_Ok() throws Exception {
        InMemoryAggregationHashChain chain = this.load("signatures/single-long-aggregation-hash-chain-ok.tlv");
        Assert.assertEquals((String)chain.getChainIdentity(" :: "), (String)"GT :: testA :: B :: A");
    }

    private InMemoryAggregationHashChain load(String file) throws Exception {
        return new InMemoryAggregationHashChain(CommonTestUtil.loadTlv((String)file).getFirstChildElement(2049));
    }
}

