/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.unisignature.inmemory.InMemoryCalendarAuthenticationRecord;
import com.guardtime.ksi.unisignature.inmemory.InvalidCalendarAuthenticationRecordException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CalendarAuthenticationRecordTest {
    @Test
    public void testDecodeCalendarAuthenticationRecord_Ok() throws Exception {
        InMemoryCalendarAuthenticationRecord record = this.load("signatures/ok-sig-2017-03-14.ksig");
        Assert.assertNotNull((Object)record.getPublicationData());
        Assert.assertNotNull((Object)record.getSignatureData());
    }

    @Test(expectedExceptions={InvalidCalendarAuthenticationRecordException.class}, expectedExceptionsMessageRegExp="Calendar authentication does not contain publication data")
    public void testDecodeCalendarAuthenticationRecordWithoutPublicationData_ThrowsInvalidCalendarAuthenticationRecordException() throws Exception {
        this.load("invalid-signatures/calendar-authentication-record/invalid-signature-cal-auth-rec-pub-data-missing-tag.tlv");
    }

    @Test(expectedExceptions={InvalidCalendarAuthenticationRecordException.class}, expectedExceptionsMessageRegExp="Calendar authentication record does not contain signature data")
    public void testDecodeCalendarAuthenticationRecordWithoutSignatureData_ThrowsInvalidCalendarAuthenticationRecordException() throws Exception {
        this.load("invalid-signatures/calendar-authentication-record/invalid-signature-cal-auth-rec-sig-data-missing-tag.tlv");
    }

    private InMemoryCalendarAuthenticationRecord load(String file) throws Exception {
        return new InMemoryCalendarAuthenticationRecord(CommonTestUtil.loadTlv((String)file).getFirstChildElement(2053));
    }
}

