/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.unisignature.inmemory.InMemoryCalendarHashChain;
import com.guardtime.ksi.unisignature.inmemory.InvalidCalendarHashChainException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CalendarHashChainTest {
    @Test
    public void testDecodeCalendarHashChain_Ok() throws Exception {
        InMemoryCalendarHashChain calendarHashChain = CalendarHashChainTest.load("components/calendar-hash-chain/calendar-hash-chain-ok.tlv");
        Assert.assertNotNull((Object)calendarHashChain.getAggregationTime());
        Assert.assertNotNull((Object)calendarHashChain.getAggregationTime());
        Assert.assertNotNull((Object)calendarHashChain.getElementType(), (String)String.valueOf(2050));
        Assert.assertEquals((long)calendarHashChain.getAggregationTime().getTime(), (long)1398153270000L);
    }

    @Test(expectedExceptions={InvalidCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Invalid calendar hash chain. Hash algorithm SHA3-256 is not implemented")
    public void testDecodeCalendarHashChainContainingInvalidHashAlgorithm_ThrowsInvalidCalendarHashChainException() throws Exception {
        CalendarHashChainTest.load("components/calendar-hash-chain/calendar-hash-chain-invalid-algorithm.tlv");
    }

    @Test(expectedExceptions={InvalidCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Calendar hash chain publication time is missing")
    public void testDecodeCalendarHashChainWithoutPublicationTime_ThrowsInvalidCalendarHashChainException() throws Exception {
        CalendarHashChainTest.load("invalid-signatures/calendar-hash-chain/invalid-signature-calendar-chain-pub-time-missing-tag.tlv", 2050);
    }

    @Test(expectedExceptions={InvalidCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Calendar hash chain input hash is missing")
    public void testDecodeCalendarHashChainWithoutInputHash_ThrowsInvalidCalendarHashChainException() throws Exception {
        CalendarHashChainTest.load("invalid-signatures/calendar-hash-chain/invalid-signature-calendar-chain-input-hash-missing-tag.tlv", 2050);
    }

    @Test(expectedExceptions={InvalidCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Calendar hash chain does not contain link elements")
    public void testDecodeCalendarHashChainWithoutLinks_ThrowsInvalidCalendarHashChainException() throws Exception {
        CalendarHashChainTest.load("invalid-signatures/calendar-hash-chain/invalid-signature-calendar-chain-right-link-left-link-missing-tags.tlv", 2050);
    }

    @Test
    public void testGetRegistrationTimeFromCalendarHashChain_Ok() throws Exception {
        InMemoryCalendarHashChain calendarHashChain = CalendarHashChainTest.load("components/calendar-hash-chain/calendar-hash-chain-ok.tlv");
        Assert.assertEquals((long)calendarHashChain.getAggregationTime().getTime(), (long)1398153270000L);
    }

    @Test
    public void testCalculateCalendarHashChainOutputHash_Ok() throws Exception {
        InMemoryCalendarHashChain calendarHashChain = CalendarHashChainTest.load("components/calendar-hash-chain/calendar-hash-chain-ok.tlv");
        Assert.assertEquals((Object)calendarHashChain.getInputHash(), (Object)new DataHash(HashAlgorithm.SHA1, new byte[]{-95, 124, -102, -86, 97, -24, 10, 27, -9, 29, 13, -123, 10, -12, -27, -70, -87, -128, 11, -67}));
        Assert.assertEquals((Object)calendarHashChain.getOutputHash(), (Object)new DataHash(HashAlgorithm.SHA2_256, new byte[]{-118, 71, 62, 38, 49, -108, 26, -97, 14, 78, -13, -19, -53, 77, -14, -74, 125, -85, -30, -126, -120, 41, -60, -47, -41, -82, 60, -104, -22, -40, 13, 58}));
    }

    @Test
    public void testGetPublicationDataFromCalendarHashChain_Ok() throws Exception {
        InMemoryCalendarHashChain calendarHashChain = CalendarHashChainTest.load("components/calendar-hash-chain/calendar-hash-chain-ok.tlv");
        PublicationData publicationData = calendarHashChain.getPublicationData();
        Assert.assertNotNull((Object)publicationData.getPublicationTime());
        Assert.assertNotNull((Object)publicationData.getPublicationDataHash());
        Assert.assertEquals((Object)publicationData.getPublicationDataHash(), (Object)new DataHash(HashAlgorithm.SHA2_256, new byte[]{-118, 71, 62, 38, 49, -108, 26, -97, 14, 78, -13, -19, -53, 77, -14, -74, 125, -85, -30, -126, -120, 41, -60, -47, -41, -82, 60, -104, -22, -40, 13, 58}));
        Assert.assertEquals((long)publicationData.getPublicationTime().getTime(), (long)1398154864000L);
    }

    static InMemoryCalendarHashChain load(String file) throws Exception {
        return new InMemoryCalendarHashChain(CommonTestUtil.loadTlv((String)file));
    }

    static InMemoryCalendarHashChain load(String file, int type) throws Exception {
        return new InMemoryCalendarHashChain(CommonTestUtil.loadTlv((String)file).getFirstChildElement(type));
    }
}

