/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.policies;

import com.guardtime.ksi.PublicationsHandler;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.unisignature.verifier.policies.PolicyContext;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class PolicyContextTest {
    @Test
    public void testPolicyContextWithoutParams() {
        PolicyContext pc = new PolicyContext();
        AssertJUnit.assertFalse((boolean)pc.isExtendingAllowed());
        Assert.assertNull((Object)pc.getExtendingService());
        Assert.assertNull((Object)pc.getPublicationsHandler());
        Assert.assertNull((Object)pc.getUserPublication());
    }

    @Test
    public void testPolicyContextWithExtender() {
        PolicyContext pc = new PolicyContext((KSIExtendingService)Mockito.mock(KSIExtendingService.class));
        AssertJUnit.assertTrue((boolean)pc.isExtendingAllowed());
        Assert.assertNotNull((Object)pc.getExtendingService());
        Assert.assertNull((Object)pc.getPublicationsHandler());
        Assert.assertNull((Object)pc.getUserPublication());
    }

    @Test
    public void testPolicyContextWithPublicationsHandlerExtender() {
        PolicyContext pc = new PolicyContext((PublicationsHandler)Mockito.mock(PublicationsHandler.class), (KSIExtendingService)Mockito.mock(KSIExtendingService.class));
        AssertJUnit.assertTrue((boolean)pc.isExtendingAllowed());
        Assert.assertNotNull((Object)pc.getExtendingService());
        Assert.assertNotNull((Object)pc.getPublicationsHandler());
        Assert.assertNull((Object)pc.getUserPublication());
    }

    @Test
    public void testPolicyContextWithPublicationData() {
        PolicyContext pc = new PolicyContext((PublicationData)Mockito.mock(PublicationData.class));
        AssertJUnit.assertFalse((boolean)pc.isExtendingAllowed());
        Assert.assertNull((Object)pc.getExtendingService());
        Assert.assertNull((Object)pc.getPublicationsHandler());
        Assert.assertNotNull((Object)pc.getUserPublication());
    }

    @Test
    public void testPolicyContextWithPublicationDataExtender() {
        PolicyContext pc = new PolicyContext((PublicationData)Mockito.mock(PublicationData.class), (KSIExtendingService)Mockito.mock(KSIExtendingService.class));
        AssertJUnit.assertTrue((boolean)pc.isExtendingAllowed());
        Assert.assertNotNull((Object)pc.getExtendingService());
        Assert.assertNull((Object)pc.getPublicationsHandler());
        Assert.assertNotNull((Object)pc.getUserPublication());
    }
}

