/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.CalendarHashChainInputHashVerificationRule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CalendarHashChainInputHashVerificationRuleTest
extends AbstractRuleTest {
    private CalendarHashChainInputHashVerificationRule rule = new CalendarHashChainInputHashVerificationRule();

    @Test
    public void testSignatureWithInvalidCalendarHashChainReturnsFailStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/calendar-hash-chain/invalid-signature-calendar-chain-input-hash-wrong.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.INT_03);
    }

    @Test
    public void testSignatureWithoutCalendarHashChainReturnsOkStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/signature-only-aggregation-chains.ksig")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testVerifySignatureWithCorrectCalendarHashChainReturnsOkStatus_Ok() throws Exception {
        Assert.assertEquals((Object)this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"))).getResultCode(), (Object)VerificationResultCode.OK);
    }
}

