/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.CertificateExistenceRule;
import java.security.cert.Certificate;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CertificateExistenceRuleTest {
    private CertificateExistenceRule rule = new CertificateExistenceRule();
    private VerificationContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.context = (VerificationContext)Mockito.mock(VerificationContext.class);
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        Mockito.when((Object)this.context.getSignature()).thenReturn((Object)signature);
        Mockito.when((Object)this.context.getCalendarAuthenticationRecord()).thenReturn((Object)signature.getCalendarAuthenticationRecord());
        Mockito.when((Object)this.context.getCertificate((byte[])Mockito.any(byte[].class))).thenReturn(null);
    }

    @Test
    public void testWhenCertificateNotPresentThenRuleReturnsFailedStatus_Ok() throws Exception {
        Mockito.when((Object)this.context.getCertificate((byte[])Mockito.any(byte[].class))).thenReturn(null);
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }

    @Test
    public void testWhenCertificateIsPresentThenRuleReturnsOkStatus_Ok() throws Exception {
        Certificate mockedCertificate = (Certificate)Mockito.mock(Certificate.class);
        Mockito.when((Object)this.context.getCertificate((byte[])Mockito.any(byte[].class))).thenReturn((Object)mockedCertificate);
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }
}

