/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.CertificateValidityRule;
import java.security.cert.Certificate;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CertificateValidityRuleTest
extends AbstractRuleTest {
    private CertificateValidityRule rule = new CertificateValidityRule();

    @Test
    public void testCertificateIsValid() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testExpiredCertificate() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("policy-verification-signatures/policy-verification-signature-aggregation-time-after-cert-time-KEY-03.ksig")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.KEY_03);
    }

    @Test
    public void testCertificateNotYetValid() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("policy-verification-signatures/policy-verification-signature-aggregation-time-before-cert-time-KEY-03.ksig")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.KEY_03);
    }

    @Test
    public void testNonX509Certificate() throws Exception {
        VerificationContext context = (VerificationContext)Mockito.mock(VerificationContext.class);
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        Mockito.when((Object)context.getSignature()).thenReturn((Object)signature);
        Mockito.when((Object)context.getCalendarAuthenticationRecord()).thenReturn((Object)signature.getCalendarAuthenticationRecord());
        Mockito.when((Object)context.getCertificate((byte[])Mockito.any(byte[].class))).thenReturn(Mockito.mock(Certificate.class));
        RuleResult result = this.rule.verify(context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.KEY_03);
    }
}

