/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.DocumentHashAlgorithmVerificationRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DocumentHashAlgorithmVerificationRuleTest
extends AbstractRuleTest {
    private Rule rule = new DocumentHashAlgorithmVerificationRule();

    @Test
    public void testSignatureVerificationWithoutDocumentHashReturnsOkStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testSignatureVerificationWithValidDocumentHashReturnsOkStatus_Ok() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        Assert.assertEquals((Object)this.rule.verify(this.build(signature, signature.getInputHash())).getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testSignatureVerificationWithInvalidDocumentHashAlgorithm() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), new DataHash(HashAlgorithm.SHA2_512, new byte[64])));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_04);
    }

    @Test
    public void testSignatureVerificationWithInvalidRfc3161OutputHashReturnsFailStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig"), new DataHash(HashAlgorithm.SHA2_512, new byte[64])));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_04);
    }
}

