/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.InputHashLevelVerificationRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InputHashLevelVerificationRuleTest
extends AbstractRuleTest {
    private Rule rule = new InputHashLevelVerificationRule();

    @Test
    public void testLevelNotProvided() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/signature-provided-input-hash-level-is-5.ksig");
        RuleResult result = this.rule.verify(this.build(signature));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testProvidedLevelSmaller() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/signature-provided-input-hash-level-is-5.ksig");
        RuleResult result = this.rule.verify(this.build(signature, 4L));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testProvidedLevelEqual() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/signature-provided-input-hash-level-is-5.ksig"), 5L));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testProvidedLevelBigger() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/signature-provided-input-hash-level-is-5.ksig"), 11L));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_03);
    }

    @Test
    public void testRfc3161SignatureProvidedLevelZero() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig");
        RuleResult result = this.rule.verify(this.build(signature, 0L));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testRfc3161SignatureProvidedLevelOne() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig");
        RuleResult result = this.rule.verify(this.build(signature, 1L));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_03);
    }
}

