/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.BaseRule;
import com.guardtime.ksi.unisignature.verifier.rules.CompositeRule;
import com.guardtime.ksi.unisignature.verifier.rules.NotRule;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import com.guardtime.ksi.util.Util;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NotRuleTest
extends AbstractRuleTest {
    private VerificationContext context = (VerificationContext)Mockito.mock(VerificationContext.class);
    Rule ruleOk = new TestRule(VerificationResultCode.OK, null);
    Rule ruleNa = new TestRule(VerificationResultCode.NA, VerificationErrorCode.GEN_02);
    Rule ruleFail = new TestRule(VerificationResultCode.FAIL, VerificationErrorCode.GEN_01);

    @Test
    public void testNotOkResult_NA() throws KSIException {
        RuleResult ruleResult = new NotRule(this.ruleOk).verify(this.context);
        this.verifyResults(ruleResult, VerificationResultCode.NA, VerificationErrorCode.GEN_02, "Not TestRule");
    }

    @Test
    public void testNotNaResult_OK() throws KSIException {
        RuleResult ruleResult = new NotRule(this.ruleNa).verify(this.context);
        this.verifyResults(ruleResult, VerificationResultCode.OK, null, "Not TestRule");
    }

    @Test
    public void testNotFailResult_FAIL() throws KSIException {
        RuleResult ruleResult = new NotRule(this.ruleFail).verify(this.context);
        this.verifyResults(ruleResult, VerificationResultCode.FAIL, VerificationErrorCode.GEN_01, "Not TestRule");
    }

    @Test
    public void testCompositeRuleNotOkResult_NA() throws KSIException {
        NotRule rule = new NotRule((Rule)new CompositeRule(true, new Rule[]{this.ruleOk, this.ruleFail, this.ruleNa}));
        RuleResult ruleResult = rule.verify(this.context);
        this.verifyResults(ruleResult, VerificationResultCode.NA, VerificationErrorCode.GEN_02, "Not TestRule,");
    }

    @Test
    public void testCompositeRuleNotNAResult_OK() throws KSIException {
        NotRule rule = new NotRule((Rule)new CompositeRule(false, new Rule[]{this.ruleNa, this.ruleFail, this.ruleOk}));
        RuleResult ruleResult = rule.verify(this.context);
        this.verifyResults(ruleResult, VerificationResultCode.OK, null, "Not TestRule,");
    }

    @Test
    public void testCompositeRuleNotFailResult_Fail() throws KSIException {
        NotRule rule = new NotRule((Rule)new CompositeRule(false, new Rule[]{this.ruleFail, this.ruleOk, this.ruleNa}));
        RuleResult ruleResult = rule.verify(this.context);
        this.verifyResults(ruleResult, VerificationResultCode.FAIL, VerificationErrorCode.GEN_01, "Not TestRule,");
    }

    private void verifyResults(RuleResult result, VerificationResultCode resultCode, VerificationErrorCode errorCode, String ruleNameStartsWith) {
        Assert.assertEquals((Object)result.getResultCode(), (Object)resultCode);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)errorCode);
        Assert.assertTrue((boolean)result.getRuleName().startsWith(ruleNameStartsWith));
    }

    private class TestRule
    extends BaseRule {
        private VerificationResultCode resultCode;
        private VerificationErrorCode errorCode;

        public TestRule(VerificationResultCode resultCode, VerificationErrorCode errorCode) {
            Util.notNull((Object)resultCode, (String)"VerificationResultCode");
            this.resultCode = resultCode;
            this.errorCode = errorCode;
        }

        VerificationResultCode verifySignature(VerificationContext context) throws KSIException {
            return this.resultCode;
        }

        VerificationErrorCode getErrorCode() {
            return this.errorCode;
        }
    }
}

