/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.PublicationsFileContainsPublicationRule;
import java.util.Date;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PublicationsFileContainsPublicationRuleTest
extends AbstractRuleTest {
    private PublicationsFileContainsPublicationRule rule = new PublicationsFileContainsPublicationRule();
    private VerificationContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.context = (VerificationContext)Mockito.mock(VerificationContext.class);
        Mockito.when((Object)this.context.getPublicationsFile()).thenReturn((Object)TestUtil.loadPublicationsFile("publications-files/publications.tlv"));
    }

    @Test
    public void testPublicationFileContainsPublication_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig"), TestUtil.loadPublicationsFile("publications-files/publications.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testSignatureDoesNotContainPublicationRecordButSuitableInPublicationsFile_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), TestUtil.loadPublicationsFile("publications-files/publications.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testPublicationFileDoesNotContainPublication_NA() throws Exception {
        KSISignature ksiSignature = (KSISignature)Mockito.mock(KSISignature.class);
        Mockito.when((Object)ksiSignature.getAggregationTime()).thenReturn((Object)new Date());
        Mockito.when((Object)this.context.getSignature()).thenReturn((Object)ksiSignature);
        Assert.assertEquals((Object)this.rule.verify(this.context).getResultCode(), (Object)VerificationResultCode.NA);
    }
}

