/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationsFile;
import com.guardtime.ksi.unisignature.inmemory.InMemorySignaturePublicationRecord;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.PublicationsFileContainsSignaturePublicationRule;
import java.util.Date;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PublicationsFileContainsSignaturePublicationRuleTest
extends AbstractRuleTest {
    private PublicationsFileContainsSignaturePublicationRule rule = new PublicationsFileContainsSignaturePublicationRule();
    private VerificationContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.context = (VerificationContext)Mockito.mock(VerificationContext.class);
        Mockito.when((Object)this.context.getPublicationsFile()).thenReturn((Object)TestUtil.loadPublicationsFile("publications-files/publications.tlv"));
    }

    @Test
    public void testPublicationFileContainsSignaturePublication_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig"), TestUtil.loadPublicationsFile("publications-files/publications.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testPublicationFileDoesNotContainPublication() throws Exception {
        this.mockPublication(new Date(999999999999999999L));
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
    }

    @Test
    public void testPublicationFileContainsPublicationWithDifferentPublicationTime() throws Exception {
        this.mockPublication(new Date(1000L));
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
    }

    @Test
    public void testPublicationFileContainPublicationWithDifferentHash() throws Exception {
        PublicationsFile file = TestUtil.loadPublicationsFile("publications-files/publications.tlv");
        this.mockPublication(file.getLatestPublication().getPublicationTime());
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.PUB_05);
    }

    private void mockPublication(Date publicationTime) throws KSIException {
        InMemorySignaturePublicationRecord mockedPublicationRecord = (InMemorySignaturePublicationRecord)Mockito.mock(InMemorySignaturePublicationRecord.class);
        Mockito.when((Object)mockedPublicationRecord.getPublicationData()).thenReturn((Object)new PublicationData(publicationTime, new DataHash(HashAlgorithm.SHA2_256, new byte[32])));
        Mockito.when((Object)this.context.getPublicationRecord()).thenReturn((Object)mockedPublicationRecord);
        Mockito.when((Object)mockedPublicationRecord.getPublicationTime()).thenReturn((Object)publicationTime);
    }
}

