/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.Rfc3161OutputHashAlgorithmDeprecatedRule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Rfc3161OutputHashAlgorithmDeprecatedRuleTest
extends AbstractRuleTest {
    private Rfc3161OutputHashAlgorithmDeprecatedRule rule = new Rfc3161OutputHashAlgorithmDeprecatedRule();

    @Test
    public void testSignatureContainsValidRfc3161Index() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testSignatureWithoutRfc3161RecordReturnsOkStatus_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertEquals((String)result.getRuleName(), (String)Rfc3161OutputHashAlgorithmDeprecatedRule.class.getSimpleName());
    }

    @Test
    public void testSignatureRfc3161OutputHashDeprecated() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/rfc3161-record/invalid-signature-rfc3161-and-aggregation-input-hash-has-deprecated-algorithm.tlv")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.INT_17);
    }
}

