/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.AbstractRuleTest;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import com.guardtime.ksi.unisignature.verifier.rules.SignatureInputHashAlgorithmDeprecatedRule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SignatureInputHashAlgorithmDeprecatedRuleTest
extends AbstractRuleTest {
    private Rule rule = new SignatureInputHashAlgorithmDeprecatedRule();

    @Test
    public void testSignatureVerificationWithNotDeprecatedAlgorithm_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testSignatureVerificationWithValidSha1Algorithm_Ok() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/signature-SHA1-in-aggregation-chain-input-hash.ksig");
        RuleResult result = this.rule.verify(this.build(signature));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testSignatureVerificationWithDeprecatedAlgorithm() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/aggregation-chain/invalid-signature-aggr-chain-input-hash-has-deprecated-algorithm.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.INT_13);
    }

    @Test
    public void testRfc3161SignatureVerificationWithValidSha1Algorithm_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("valid-signatures/signature-SHA1-in-rfc3161-record-input-hash.ksig")));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertNull((Object)result.getErrorCode());
    }

    @Test
    public void testRfc3161SignatureVerificationWithDeprecatedAlgorithm() throws Exception {
        RuleResult result = this.rule.verify(this.build(TestUtil.loadSignature("internal-policy-signatures/rfc3161-record/invalid-signature-rfc3161-input-hash-has-deprecated-algorithm.tlv")));
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.FAIL);
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.INT_13);
    }
}

