/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier.rules;

import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.rules.UserProvidedPublicationExistenceRule;
import java.util.Date;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UserProvidedPublicationExistenceRuleTest {
    private UserProvidedPublicationExistenceRule rule = new UserProvidedPublicationExistenceRule();
    private VerificationContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.context = (VerificationContext)Mockito.mock(VerificationContext.class);
        Mockito.when((Object)this.context.getUserProvidedPublication()).thenReturn((Object)new PublicationData(new Date(), new DataHash(HashAlgorithm.SHA2_256, new byte[32])));
    }

    @Test
    public void testUserPublicationDataExists_Ok() throws Exception {
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.OK);
    }

    @Test
    public void testUserPublicationDataDoesNotExist_Ok() throws Exception {
        Mockito.when((Object)this.context.getUserProvidedPublication()).thenReturn(null);
        RuleResult result = this.rule.verify(this.context);
        Assert.assertEquals((Object)result.getResultCode(), (Object)VerificationResultCode.NA);
    }
}

