/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.agent.rt;

import com.gzoltar.internal.agent.rt.IAgent;
import com.gzoltar.internal.agent.rt.output.ConsoleOutput;
import com.gzoltar.internal.agent.rt.output.FileOutput;
import com.gzoltar.internal.agent.rt.output.IAgentOutput;
import com.gzoltar.internal.agent.rt.output.NoneOutput;
import com.gzoltar.internal.core.AgentConfigs;
import com.gzoltar.internal.core.AgentOutput;
import com.gzoltar.internal.core.runtime.Collector;
import com.gzoltar.internal.core.spectrum.ISpectrum;

public class Agent
implements IAgent {
    private static Agent singleton;
    private final AgentConfigs agentConfigs;
    private IAgentOutput output;

    public static synchronized Agent getInstance(AgentConfigs agentConfigs) {
        if (singleton == null) {
            final Agent agent = new Agent(agentConfigs);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    agent.shutdown();
                }
            });
            singleton = agent;
        }
        return singleton;
    }

    public static synchronized Agent getInstance() {
        if (singleton == null) {
            throw new IllegalStateException("GZoltar agent has not started.");
        }
        return singleton;
    }

    private Agent(AgentConfigs agentConfigs) {
        this.agentConfigs = agentConfigs;
        this.output = this.createAgentOutput();
    }

    private IAgentOutput createAgentOutput() {
        AgentOutput controllerType = this.agentConfigs.getOutput();
        switch (controllerType) {
            case FILE: {
                return new FileOutput(this.agentConfigs);
            }
            case CONSOLE: {
                return new ConsoleOutput();
            }
            case NONE: {
                return new NoneOutput();
            }
        }
        throw new AssertionError((Object)controllerType);
    }

    @Override
    public void startup() {
        Collector.instance().addListener(this.agentConfigs.getEventListener());
    }

    @Override
    public synchronized void shutdown() {
        try {
            this.output.writeSpectrum(this.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ISpectrum getData() {
        return Collector.instance().getSpectrum();
    }
}

