/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.agent.rt;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfigLoader {
    private static final String SYS_PREFIX = "gzoltar-agent.";
    private static final Pattern SUBST_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");

    private ConfigLoader() {
    }

    public static Properties load(Properties system) {
        Properties result = new Properties();
        ConfigLoader.loadSystemProperties(system, result);
        ConfigLoader.substSystemProperties(result, system);
        return result;
    }

    private static void loadSystemProperties(Properties system, Properties result) {
        for (Map.Entry<Object, Object> entry : system.entrySet()) {
            String keystr = entry.getKey().toString();
            if (!keystr.startsWith(SYS_PREFIX)) continue;
            result.put(keystr.substring(SYS_PREFIX.length()), entry.getValue());
        }
    }

    private static void substSystemProperties(Properties result, Properties system) {
        for (Map.Entry<Object, Object> entry : result.entrySet()) {
            String oldValue = (String)entry.getValue();
            StringBuilder newValue = new StringBuilder();
            Matcher m = SUBST_PATTERN.matcher(oldValue);
            int pos = 0;
            while (m.find()) {
                newValue.append(oldValue.substring(pos, m.start()));
                String sub = system.getProperty(m.group(1));
                newValue.append(sub == null ? m.group(0) : sub);
                pos = m.end();
            }
            newValue.append(oldValue.substring(pos));
            entry.setValue(newValue.toString());
        }
    }
}

