/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.agent.rt;

import com.gzoltar.internal.core.AgentConfigs;
import com.gzoltar.internal.core.instr.Instrumenter;
import com.gzoltar.internal.core.instr.Outcome;
import com.gzoltar.internal.core.instr.actions.BlackList;
import com.gzoltar.internal.core.instr.actions.WhiteList;
import com.gzoltar.internal.core.instr.filter.Filter;
import com.gzoltar.internal.core.instr.matchers.ClassNameMatcher;
import com.gzoltar.internal.core.instr.matchers.PrefixMatcher;
import com.gzoltar.internal.core.instr.matchers.SourceLocationMatcher;
import com.gzoltar.internal.javassist.ClassPool;
import com.gzoltar.internal.javassist.CtClass;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;

public class CoverageTransformer
implements ClassFileTransformer {
    private final Instrumenter instrumenter;
    private final String buildLocation;
    private final boolean inclNoLocationClasses;
    private final Filter filter;

    public CoverageTransformer(AgentConfigs agentConfigs) throws Exception {
        this.instrumenter = new Instrumenter(agentConfigs);
        this.buildLocation = new File(agentConfigs.getBuildLocation()).getCanonicalPath();
        this.inclNoLocationClasses = agentConfigs.getInclNoLocationClasses();
        BlackList excludeGZoltarClasses = new BlackList(new PrefixMatcher("com.gzoltar.internal."));
        WhiteList includeClasses = new WhiteList(new ClassNameMatcher(agentConfigs.getIncludes()));
        BlackList excludeClasses = new BlackList(new ClassNameMatcher(agentConfigs.getExcludes()));
        BlackList excludeClassLoaders = new BlackList(new ClassNameMatcher(agentConfigs.getExclClassloader()));
        this.filter = new Filter(excludeGZoltarClasses, includeClasses, excludeClasses, excludeClassLoaders);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (loader == null) {
            return null;
        }
        if (classBeingRedefined != null) {
            return null;
        }
        try {
            ClassPool cp = ClassPool.getDefault();
            CtClass cc = cp.makeClassIfNew(new ByteArrayInputStream(classfileBuffer));
            SourceLocationMatcher excludeClassesNotInBuildLocation = new SourceLocationMatcher(this.inclNoLocationClasses, this.buildLocation, protectionDomain);
            if (!excludeClassesNotInBuildLocation.matches(cc)) {
                return null;
            }
            if (this.filter.filter(cc) == Outcome.REJECT) {
                return null;
            }
            return this.instrumenter.instrument(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

