/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.agent.rt.output;

import com.gzoltar.internal.agent.rt.output.IAgentOutput;
import com.gzoltar.internal.core.AgentConfigs;
import com.gzoltar.internal.core.spectrum.ISpectrum;
import com.gzoltar.internal.core.spectrum.SpectrumWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutput
implements IAgentOutput {
    private final File destFile;

    public FileOutput(AgentConfigs agentConfigs) {
        this.destFile = new File(agentConfigs.getDestfile()).getAbsoluteFile();
        File folder = this.destFile.getParentFile();
        if (folder != null) {
            folder.mkdirs();
        }
        try {
            this.openFile().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSpectrum(ISpectrum spectrum) throws Exception {
        try (OutputStream output = this.openFile();){
            SpectrumWriter writer = new SpectrumWriter(output);
            writer.writeSpectrum(spectrum);
        }
    }

    private OutputStream openFile() throws IOException {
        FileOutputStream file = new FileOutputStream(this.destFile, true);
        file.getChannel().lock();
        return file;
    }
}

