/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core;

import com.gzoltar.internal.core.AgentOutput;
import com.gzoltar.internal.core.events.EmptyEventListener;
import com.gzoltar.internal.core.events.IEventListener;
import com.gzoltar.internal.core.instr.InstrumentationLevel;
import com.gzoltar.internal.core.instr.granularity.GranularityLevel;
import com.gzoltar.internal.core.util.CommandLineSupport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public final class AgentConfigs {
    public static final String BUILDLOCATION_KEY = "buildlocation";
    public static final String DEFAULT_BUILDLOCATION = "";
    public static final String DESTFILE_KEY = "destfile";
    public static final String DEFAULT_DESTFILE = "gzoltar.ser";
    public static final String INCLUDES_KEY = "includes";
    public static final String DEFAULT_INCLUDES = "*";
    public static final String EXCLUDES_KEY = "excludes";
    public static final String DEFAULT_EXCLUDES = "";
    public static final String EXCLCLASSLOADER_KEY = "exclclassloader";
    public static final String DEFAULT_EXCLCLASSLOADER = "sun.reflect.DelegatingClassLoader";
    public static final String INCLNOLOCATIONCLASSES_KEY = "inclnolocationclasses";
    public static final boolean DEFAULT_INCLNOLOCATIONCLASSES = false;
    public static final String OUTPUT_KEY = "output";
    public static final AgentOutput DEFAULT_OUTPUT = AgentOutput.FILE;
    public static final String GRANULARITY_KEY = "granularity";
    public static final GranularityLevel DEFAULT_GRANULARITY = GranularityLevel.LINE;
    public static final String INCLPUBLICMETHODS_KEY = "inclpublicmethods";
    public static final boolean DEFAULT_INCLPUBLICMETHODS = true;
    public static final String INCLSTATICCONSTRUCTORS_KEY = "inclstaticconstructors";
    public static final boolean DEFAULT_INCLSTATICCONSTRUCTORS = true;
    public static final String INCLDEPRECATEDMETHODS_KEY = "incldeprecatedmethods";
    public static final boolean DEFAULT_INCLDEPRECATEDMETHODS = true;
    public static final String INSTRUMENTATION_LEVEL_KEY = "instrumentation_level";
    public static final InstrumentationLevel DEFAULT_INSTRUMENTATION_LEVEL = InstrumentationLevel.FULL;
    private final Map<String, String> configs = new HashMap<String, String>();
    private static final Collection<String> VALID_CONFIGS = Arrays.asList("buildlocation", "destfile", "includes", "excludes", "exclclassloader", "inclnolocationclasses", "output", "granularity", "inclpublicmethods", "inclstaticconstructors", "incldeprecatedmethods");
    private static final Pattern CONFIG_SPLIT = Pattern.compile(",(?=[a-zA-Z0-9_\\-]+=)");

    public AgentConfigs() {
    }

    public AgentConfigs(String agentConfigs) {
        this();
        if (agentConfigs != null && agentConfigs.length() > 0) {
            for (String entry : CONFIG_SPLIT.split(agentConfigs)) {
                int pos = entry.indexOf(61);
                if (pos == -1) {
                    throw new IllegalArgumentException(String.format("Invalid agent configuration syntax \"%s\".", agentConfigs));
                }
                String key = entry.substring(0, pos);
                if (!VALID_CONFIGS.contains(key)) {
                    throw new IllegalArgumentException(String.format("Unknown agent configuration \"%s\".", key));
                }
                String value = entry.substring(pos + 1);
                this.setConfig(key, value);
            }
        }
    }

    public AgentConfigs(Properties properties) {
        this();
        for (String key : VALID_CONFIGS) {
            String value = properties.getProperty(key);
            if (value == null) continue;
            this.setConfig(key, value);
        }
    }

    private void setConfig(String key, String value) {
        this.configs.put(key, value);
    }

    private String getConfig(String key, String defaultValue) {
        String value = this.configs.get(key);
        return value == null ? defaultValue : value;
    }

    private void setConfig(String key, boolean value) {
        this.setConfig(key, Boolean.toString(value));
    }

    private boolean getConfig(String key, boolean defaultValue) {
        String value = this.configs.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public String getBuildLocation() {
        return this.getConfig(BUILDLOCATION_KEY, "");
    }

    public void setBuildLocation(String buildLocation) {
        this.setConfig(BUILDLOCATION_KEY, buildLocation);
    }

    public String getDestfile() {
        return this.getConfig(DESTFILE_KEY, DEFAULT_DESTFILE);
    }

    public void setDestfile(String destfile) {
        this.setConfig(DESTFILE_KEY, destfile);
    }

    public String getIncludes() {
        String includes = this.getConfig(INCLUDES_KEY, DEFAULT_INCLUDES);
        if (!includes.isEmpty() && new File(includes).exists()) {
            try {
                includes = new String(Files.readAllBytes(Paths.get(includes, new String[0])), Charset.defaultCharset());
            }
            catch (IOException e) {
                e.printStackTrace();
                includes = DEFAULT_INCLUDES;
            }
        }
        return includes;
    }

    public void setIncludes(String includes) {
        this.setConfig(INCLUDES_KEY, includes);
    }

    public String getExcludes() {
        String excludes = this.getConfig(EXCLUDES_KEY, "");
        if (!excludes.isEmpty() && new File(excludes).exists()) {
            try {
                excludes = new String(Files.readAllBytes(Paths.get(excludes, new String[0])), Charset.defaultCharset());
            }
            catch (IOException e) {
                e.printStackTrace();
                excludes = "";
            }
        }
        return excludes;
    }

    public void setExcludes(String excludes) {
        this.setConfig(EXCLUDES_KEY, excludes);
    }

    public String getExclClassloader() {
        return this.getConfig(EXCLCLASSLOADER_KEY, DEFAULT_EXCLCLASSLOADER);
    }

    public void setExclClassloader(String expression) {
        this.setConfig(EXCLCLASSLOADER_KEY, expression);
    }

    public boolean getInclNoLocationClasses() {
        return this.getConfig(INCLNOLOCATIONCLASSES_KEY, false);
    }

    public void setInclNoLocationClasses(boolean include) {
        this.setConfig(INCLNOLOCATIONCLASSES_KEY, include);
    }

    public AgentOutput getOutput() {
        String value = this.configs.get(OUTPUT_KEY);
        return value == null ? DEFAULT_OUTPUT : AgentOutput.valueOf(value);
    }

    public void setOutput(String output) {
        this.setOutput(AgentOutput.valueOf(output.toUpperCase()));
    }

    public void setOutput(AgentOutput output) {
        this.setConfig(OUTPUT_KEY, output.name());
    }

    public GranularityLevel getGranularity() {
        String value = this.configs.get(GRANULARITY_KEY);
        return value == null ? DEFAULT_GRANULARITY : GranularityLevel.valueOf(value);
    }

    public void setGranularity(String granularity) {
        this.setGranularity(GranularityLevel.valueOf(granularity.toUpperCase()));
    }

    public void setGranularity(GranularityLevel granularity) {
        this.setConfig(GRANULARITY_KEY, granularity.name());
    }

    public Boolean getInclPublicMethods() {
        return this.getConfig(INCLPUBLICMETHODS_KEY, true);
    }

    public void setInclPublicMethods(boolean inclPublicMethods) {
        this.setConfig(INCLPUBLICMETHODS_KEY, inclPublicMethods);
    }

    public Boolean getInclStaticConstructors() {
        return this.getConfig(INCLSTATICCONSTRUCTORS_KEY, true);
    }

    public void setInclStaticConstructors(boolean inclStaticConstructors) {
        this.setConfig(INCLSTATICCONSTRUCTORS_KEY, inclStaticConstructors);
    }

    public Boolean getInclDeprecatedMethods() {
        return this.getConfig(INCLDEPRECATEDMETHODS_KEY, true);
    }

    public void setInclDeprecatedMethods(boolean inclDeprecatedMethods) {
        this.setConfig(INCLDEPRECATEDMETHODS_KEY, inclDeprecatedMethods);
    }

    public InstrumentationLevel getInstrumentationLevel() {
        String value = this.configs.get(INSTRUMENTATION_LEVEL_KEY);
        return value == null ? DEFAULT_INSTRUMENTATION_LEVEL : InstrumentationLevel.valueOf(value);
    }

    public void setInstrumentationLevel(String instrumentationLevel) {
        this.setInstrumentationLevel(InstrumentationLevel.valueOf(instrumentationLevel.toUpperCase()));
    }

    public void setInstrumentationLevel(InstrumentationLevel instrumentationLevel) {
        this.setConfig(INSTRUMENTATION_LEVEL_KEY, instrumentationLevel.name());
    }

    public IEventListener getEventListener() {
        return new EmptyEventListener();
    }

    public String getVMArgument(File agentJarFile) {
        return String.format("-javaagent:%s=%s", agentJarFile, this);
    }

    public String getQuotedVMArgument(File agentJarFile) {
        return CommandLineSupport.quote(this.getVMArgument(agentJarFile));
    }

    public String prependVMArguments(String arguments, File agentJarFile) {
        List<String> args = CommandLineSupport.split(arguments);
        String plainAgent = String.format("-javaagent:%s", agentJarFile);
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            if (!i.next().startsWith(plainAgent)) continue;
            i.remove();
        }
        args.add(0, this.getVMArgument(agentJarFile));
        return CommandLineSupport.quote(args);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : VALID_CONFIGS) {
            String value = this.configs.get(key);
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key).append('=').append(value);
        }
        return sb.toString();
    }
}

