/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr;

import com.gzoltar.internal.core.AgentConfigs;
import com.gzoltar.internal.core.instr.pass.IPass;
import com.gzoltar.internal.core.instr.pass.InstrumentationPass;
import com.gzoltar.internal.javassist.ClassPool;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.org.jacoco.core.internal.ContentTypeDetector;
import com.gzoltar.internal.org.jacoco.core.internal.Pack200Streams;
import com.gzoltar.internal.org.jacoco.core.internal.instr.SignatureRemover;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Instrumenter {
    private final IPass[] passes;
    private final SignatureRemover signatureRemover;

    public Instrumenter(AgentConfigs agentConfigs) {
        this.passes = new IPass[]{new InstrumentationPass(agentConfigs)};
        this.signatureRemover = new SignatureRemover();
    }

    public void setRemoveSignatures(boolean flag) {
        this.signatureRemover.setActive(flag);
    }

    public byte[] instrument(byte[] classfileBuffer) throws Exception {
        return this.instrument(new ByteArrayInputStream(classfileBuffer));
    }

    public byte[] instrument(InputStream sourceStream) throws Exception {
        CtClass cc = ClassPool.getDefault().makeClassIfNew(sourceStream);
        return this.instrument(cc);
    }

    public byte[] instrument(CtClass cc) throws Exception {
        for (IPass p : this.passes) {
            switch (p.transform(cc)) {
                case REJECT: {
                    cc.detach();
                    return null;
                }
            }
        }
        byte[] bytecode = cc.toBytecode();
        return bytecode;
    }

    public int instrumentToFile(InputStream input, OutputStream output) throws Exception {
        ContentTypeDetector detector = new ContentTypeDetector(input);
        switch (detector.getType()) {
            case -889275714: {
                output.write(this.instrument(detector.getInputStream()));
                return 1;
            }
            case 529203200: {
                return this.instrumentGzip(detector.getInputStream(), output);
            }
            case -889270259: {
                return this.instrumentPack200(detector.getInputStream(), output);
            }
            case 1347093252: {
                return this.instrumentZip(detector.getInputStream(), output);
            }
        }
        this.copy(detector.getInputStream(), output);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int instrument(File source, File dest) throws Exception {
        dest.getParentFile().mkdirs();
        try (FileInputStream input = new FileInputStream(source);){
            int n;
            FileOutputStream output = new FileOutputStream(dest);
            try {
                n = this.instrumentToFile(input, output);
            }
            catch (Throwable throwable) {
                ((OutputStream)output).close();
                throw throwable;
            }
            ((OutputStream)output).close();
            return n;
        }
    }

    public int instrumentRecursively(File source, File dest) throws Exception {
        int numInstrumentedClasses = 0;
        if (source.isDirectory()) {
            ClassPool.getDefault().appendClassPath(source.getAbsolutePath());
            for (File child : source.listFiles()) {
                numInstrumentedClasses += this.instrumentRecursively(child, new File(dest, child.getName()));
            }
        } else {
            numInstrumentedClasses += this.instrument(source, dest);
        }
        return numInstrumentedClasses;
    }

    private int instrumentGzip(InputStream input, OutputStream output) throws Exception {
        GZIPInputStream gzipInputStream = new GZIPInputStream(input);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(output);
        int count = this.instrumentToFile(gzipInputStream, gzipOutputStream);
        gzipOutputStream.finish();
        return count;
    }

    private int instrumentPack200(InputStream input, OutputStream output) throws Exception {
        InputStream unpackedInput = Pack200Streams.unpack(input);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int count = this.instrumentToFile(unpackedInput, buffer);
        Pack200Streams.pack(buffer.toByteArray(), output);
        return count;
    }

    private int instrumentZip(InputStream input, OutputStream output) throws Exception {
        ZipEntry entry;
        ZipInputStream zipInputStream = new ZipInputStream(input);
        ZipOutputStream zipOutputStream = new ZipOutputStream(output);
        int count = 0;
        while ((entry = zipInputStream.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (this.signatureRemover.removeEntry(entryName)) continue;
            zipOutputStream.putNextEntry(new ZipEntry(entryName));
            if (!this.signatureRemover.filterEntry(entryName, zipInputStream, zipOutputStream)) {
                count += this.instrumentToFile(zipInputStream, zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
        zipOutputStream.finish();
        return count;
    }

    private void copy(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }
}

