/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr;

import com.gzoltar.internal.core.runtime.Collector;
import com.gzoltar.internal.javassist.CannotCompileException;
import com.gzoltar.internal.javassist.ClassPool;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.CtConstructor;
import com.gzoltar.internal.javassist.CtField;
import com.gzoltar.internal.javassist.expr.ExprEditor;
import com.gzoltar.internal.javassist.expr.FieldAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;

public final class SystemClassInstrumenter {
    public static void instrumentSystemClass(Instrumentation inst, final String className, final String accessFieldName) throws Exception {
        final ClassPool cp = ClassPool.getDefault();
        ClassFileTransformer transformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String name, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] source) throws IllegalClassFormatException {
                if (name.equals(className)) {
                    try {
                        CtClass cc = cp.makeClass(new ByteArrayInputStream(source));
                        byte[] bytes = SystemClassInstrumenter.instrument(cc, accessFieldName);
                        return bytes;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
        inst.addTransformer(transformer);
        Class<?> clazz = Class.forName("java.lang.UnknownError");
        inst.removeTransformer(transformer);
        try {
            Field field = clazz.getField(accessFieldName);
            field.set(null, Collector.instance());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Class '" + className + "' could not be instrumented.", e);
        }
    }

    private static byte[] instrument(CtClass ctClass, final String accessFieldName) throws IOException, CannotCompileException {
        CtField f = CtField.make("Object " + accessFieldName + ";", ctClass);
        f.setModifiers(f.getModifiers() | 0x1089);
        ctClass.addField(f);
        CtConstructor clinit = ctClass.makeClassInitializer();
        clinit.instrument(new ExprEditor(){

            @Override
            public void edit(FieldAccess f) throws CannotCompileException {
                if (f.getFieldName().equals(accessFieldName)) {
                    f.replace("{ $_ = $proceed($$); }");
                }
            }
        });
        return ctClass.toBytecode();
    }
}

