/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr.filter;

import com.gzoltar.internal.core.instr.Outcome;
import com.gzoltar.internal.core.instr.actions.BlackList;
import com.gzoltar.internal.core.instr.actions.IAction;
import com.gzoltar.internal.core.instr.filter.Filter;
import com.gzoltar.internal.core.instr.matchers.AndMatcher;
import com.gzoltar.internal.core.instr.matchers.MethodNameMatcher;
import com.gzoltar.internal.core.instr.matchers.OrMatcher;
import com.gzoltar.internal.core.instr.matchers.SuperclassMatcher;
import com.gzoltar.internal.core.util.VMUtils;
import com.gzoltar.internal.javassist.CtBehavior;
import com.gzoltar.internal.javassist.CtClass;

public final class EnumFilter
extends Filter {
    public EnumFilter() {
        super(new IAction[0]);
    }

    @Override
    public Outcome filter(CtClass ctClass) {
        IAction enumFilter = this.enumFilterAction(ctClass.getName());
        return super.filter((Object)ctClass, enumFilter);
    }

    @Override
    public Outcome filter(CtBehavior ctBehavior) {
        IAction enumFilter = this.enumFilterAction(ctBehavior.getDeclaringClass().getName());
        return super.filter((Object)ctBehavior, enumFilter);
    }

    private IAction enumFilterAction(String className) {
        String classNameWithSlash = VMUtils.toVMName(className);
        BlackList enumMethods = new BlackList(new AndMatcher(new SuperclassMatcher("java.lang.Enum"), new OrMatcher(new MethodNameMatcher("values()[L" + classNameWithSlash + ";"), new MethodNameMatcher("valueOf(Ljava/lang/String;)L" + classNameWithSlash + ";"))));
        return enumMethods;
    }
}

