/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr.granularity;

import com.gzoltar.internal.core.instr.granularity.AbstractGranularity;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.bytecode.MethodInfo;
import com.gzoltar.internal.javassist.bytecode.analysis.ControlFlow;
import java.util.LinkedList;
import java.util.Queue;

public class BasicBlockGranularity
extends AbstractGranularity {
    private Queue<Integer> blocks = new LinkedList<Integer>();

    public BasicBlockGranularity(CtClass ctClass, MethodInfo methodInfo) {
        super(ctClass, methodInfo);
        try {
            ControlFlow cf = new ControlFlow(ctClass, methodInfo);
            for (ControlFlow.Block block : cf.basicBlocks()) {
                this.blocks.add(block.position());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean instrumentAtIndex(int index, int instrumentationSize) {
        boolean outcome;
        boolean bl = outcome = !this.blocks.isEmpty() && index >= instrumentationSize + this.blocks.peek();
        if (outcome) {
            this.blocks.poll();
        }
        return outcome;
    }

    @Override
    public boolean stopInstrumenting() {
        return this.blocks.isEmpty();
    }
}

